<?php

use Sypres\Components\Evenement;
/*
 * Page Event
 * Template Name: Event
 * 
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 * 
 * @package WordPress
 * @subpackage Sypres
 * @since Sypres 1.0
 */

    $date = (new DateTime())->format('Ymd');

    $events = get_posts([
        'numberposts'      => '-1',
        'orderby'          => 'meta_value',
        'order'            => 'DESC',
        'meta_key'         => 'date',
        'meta_compare'     => '>',
        'meta_value'       => $date,
        'post_type'        => 'evenement',
    ]);

    $old_events = get_posts([
        'numberposts'      => '-1',
        'orderby'          => 'meta_value',
        'order'            => 'DESC',
        'meta_key'         => 'date',
        'meta_compare'     => '<=',
        'meta_value'       => $date,
        'post_type'        => 'evenement',
    ]);
?>

<?php get_header();?>

<div class="main event text-base">
    <?php the_content(); ?>
    <div class="container-evenement">
        <?php foreach ($events as $event): ?>
            <?php Evenement::create($event); ?>
        <?php endforeach ?>
    
        <div class="old-event text-3xl">
            <span>Déjà Passé ...</span>
            <div class="separator primary"></div>
        </div>
         
        <?php foreach ($old_events as $event): ?>
            <?php Evenement::create($event); ?>
        <?php endforeach ?>
    </div>
</div>

<?php get_footer() ?>