<?php

namespace Sypres\Navigation;

class Footer {

    public static function create() {
        $fields = get_field('colonne', 'option');
        $count = count($fields);
        $class = "grid-". ceil($count / 2 + 1);
        ?>
        <div class="footer text-base">
            <div class="row first <?= $class ?>">
                <?php Footer::getLogo(); ?>
                <?php for ($i = 0; $i < $count / 2; $i++):?>
                    <?php Footer::getColumn($fields[$i]) ?>
                <?php endfor; ?>
            </div>
            <div class="separator"></div>
            <div class="row second <?= $class ?>">
                <?php Footer::getContact() ?>
                <?php for ($i = $count / 2; $i < $count; $i++):?>
                    <?php Footer::getColumn($fields[$i]) ?>
                <?php endfor; ?>
            </div>
        </div>
        <?php  
    }

    public static function getColumn($field) {

         ?>
         <div class="column">
            <?php if ($field['type'] == "link"): ?>
                <div class="bold text-white"><?= $field['titre']; ?></div>
                <?php foreach ($field['link_list'] as $link): ?>
                    <a href="<?= $link['liens']['url'] ?>" target="<?= $link['liens']['target'] ?>"><?= $link['liens']['title'] ?></a>
                <?php endforeach; ?>

            <?php elseif ($field['type'] == "text"): ?>
                <div class="bold text-white"><?= $field['titre']; ?></div>
                <p>
                    <?= $field['texte'] ?>
                </p>

            <?php elseif ($field['type'] == "social"): ?>
                <?php $contacts = get_field('social_network', 'option'); ?>
                <div class="bold text-white">Suivez-nous sur</div>
                <div class="social">
                    <?php foreach ($contacts as $contact):?>
                        <a href="<?= $contact['url']['url'] ?>" class="<?= $contact['color_selector'] ?>">
                            <img src="<?= get_stylesheet_directory_uri().'/assets/img/icon/'.$contact['logo']; ?>" alt="">
                        </a>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
         </div>
         <?php 
    }

    public static function getLogo() {
         ?>
         <div class="column">
            <img class="logo" src="<?= get_stylesheet_directory_uri().'/assets/img/logo.webp'; ?>" alt="">
         </div>
         <?php 
    }

    public static function getContact() {
         ?>
        <?php $contact = get_field('contact', 'option'); ?>
        <div class="column">
            <div class="bold text-white">Contact</div>
            <p>
                <?= $contact['texte'] ?>
            </p>
            <a href="<?= $contact['lien']['url'] ?>" class="contact">Contact</a>
         </div>
         <?php 
    }
}