<?php 

namespace Sypres\Components;

class Value {

    public static function createContainer(
        array $boxes
    ) {
        $index = 1;
        ?>
            <div class="container-value">
                <?php foreach ($boxes as $box): ?>
                    <?php Value::create(
                        $box['title'], 
                        $box['text'],
                        $box['link'],
                        $index,
                        $box['button'] ?? "EN SAVOIR PLUS",
                        $box['target'] ?? ""
                    ); ?>
                    <?php $index++; ?>
                <?php endforeach; ?>
            </div>
        <?php 
    }

    public static function create(
        string $title, 
        string $text, 
        string $lien,
        int $index, 
        string $button = "EN SAVOIR PLUS",
        string $target = ""
    ) {
        $color =  match ($index) {
            1 => "secondary",
            2 => "primary",
            3 => "ternary",
            default => "primary"
        };
        ?>
            <div class="value <?= $color ?> text-base">
                <div class="text">
                    <h3><?= $title ?></h3>
                    <div class="separator <?= $color ?>"></div>
                    <p class="text-base"><?= $text ?></p>
                    <a href="<?= $lien ?>" target="<?= $target ?>" class="btn <?= $color ?> text-base"><?= $button ?></a>
                </div>
                <div class="img"></div>
            </div>
        <?php
    }
}

