<?php

namespace Sypres\Components;

use Sypres\Post\Thematic;

class Vignette {

    public static function createContainer() {
        $thematics = Thematic::getAll();
        ?>
            <div class="container-vignette">
                <div class="presentation-article">
                    <span>Thématiques</span>
                    <div class="separator grey"></div>
                </div>
                <!-- TODO: carousel -->
                <div class="group">
                    <?php foreach ($thematics as $thematic): ?>
                        <?php Vignette::createWithThematic($thematic) ?>
                    <?php endforeach; ?>
                </div>
            </div>
        <?php  
    }

    public static function createWithThematic($thematic) {
        if ($thematic['name'] == "Non classé") { return; }
        Vignette::create($thematic['name'], $thematic['color'], $thematic['img']);
    }

    public static function create( $name, $color, $img ) {
        $img = get_stylesheet_directory_uri().
            '/assets/img/icon/'.
            $img.'.svg';
        ?>
            <div class="vignette <?= $color ?>">
                <img src="<?= $img ?>" alt="" class="<?= $color ?>">
                <span><?= $name ?></span>
            </div>
        <?php  
    }
}