<?php 

namespace Sypres\Components;

class Temoignage {

    public static function createContainer(
        string $title,
        string $text,
        array $temoignages
    ) {
        $index = 1;
        ?>
            <div class="container-temoignage">
                <div class="presentation">
                    <h2><?= $title ?></h2>
                    <div class="separator grey"></div>
                    <span class="text-xl"><?= $text ?></span>
                </div>
                <!-- TODO: carousel -->
                <?php Carousel::createStart() ?>

                <?php foreach ($temoignages as $temoignage): ?>
                    <?php Temoignage::create(
                        $temoignage['name'], 
                        $temoignage['text'],
                        $temoignage['gender'],
                    ); ?>
                    <?php $index++; ?>
                <?php endforeach; ?>

                <?php Carousel::createEnd() ?>
            </div>
        <?php  
    }

    public static function create(
        string $name,
        string $text,
        string $gender
    ) {
        $gender = $gender == "homme" || $gender == "femme" ? $gender : "homme";
        ?>
            <div class="slide temoignage text-xl">
                <div class="header">
                    <div class="img <?= $gender ?>"></div>
                    <span class="name bold"><?= $name ?></span>
                </div>
                <div class="text"><?= $text ?></div>
            </div>
        <?php  
    }
}