<?php 

namespace Sypres\Components;

class Team {

    public static function createContainer(
        string $title,
        string $text,
        array $team
    ) {
        $index = 1;
        ?>
            <div class="container-team">
                <div class="presentation">
                    <h2><?= $title ?></h2>
                    <div class="separator lighter"></div>
                    <span class="text-xl"><?= $text ?></span>
                </div>
                <?php Carousel::createStart() ?>
                <?php foreach ($team as $member): ?>
                    <?php Team::create(
                        $member['name'], 
                        $member['role'], 
                        $member['text'],
                        $member['img']['url'],
                    ); ?>
                    <?php $index++; ?>
                <?php endforeach; ?>
                <?php Carousel::createEnd() ?>
            </div>
        <?php  
    }

    public static function create(
        string $name,
        string $role,
        string $text,
        null|string $img
    ) {
        if ( !$img ) { $img = get_stylesheet_directory_uri().'/assets/img/icon/man.webp'; }
        ?>
            <div class="team text-xl">
                <div class="header">
                    <img src="<?= $img ?>" alt="">
                    <span class="name bold"><?= $name ?></span>
                    <span class="role"><?= $role ?></span>
                    <div class="separator lighter"></div>
                </div>
                <div class="text"><?= $text ?></div>
            </div>
        <?php  
    }
}