<?php

namespace Sypres\Components;

class Paragraph {
    public static function create(
        string $type = 'simple',
        $title = "",
        string $text = "", 
        string $color = null,
        $img = null,
        $orientation = "left",
        $action =  []
    ) {
        ?>
            <?php if ( $type == 'simple'): ?>
                <div class="paragraph <?= $color ? $color : "" ?>">
                    <?php Paragraph::getTitle($title)?>
                    <div class="<?= $title ? "text-base" : "" ?>"><?= $text ?></div>
                    <?php Paragraph::getAction($action, $color) ?>
                </div>
            <?php elseif ( $type == 'background'): ?>
                <div class="paragraph background">
                    <div class="container <?= $color ? $color : "" ?>">
                        <?php Paragraph::getTitle($title)?>
                        <div class="<?= $title ? "text-base" : "" ?>"><?= $text ?></div>
                        <?php Paragraph::getAction($action, $color) ?>
                    </div>
                </div>
            <?php elseif ( $type == 'side' ): ?>
                <div class="paragraph side <?= $orientation ?>">
                    <img src="<?= $img['url'] ?>" alt="">
                    <div class="container <?= $color ? $color : "" ?>">
                        <?php Paragraph::getTitle($title)?>
                        <div class="<?= $title ? "text-base" : "" ?>"><?= $text ?></div>
                        <?php Paragraph::getAction($action, $color) ?>
                    </div>
                </div>
            <?php endif; ?>
        <?php 
    }

    public static function getTitle( $title, $color = null ) {
        if ( !$title ) { return; }
        ?>
            <h2 class="<?php $color ?>"><?= $title ?></h2>
            <div class="separator <?= $color ? $color : "grey" ?>"></div>
        <?php  
    }

    public static function getAction($action, $color = null ) {
        if ( count($action) == 0 ) { return; }
        Action::create($action['title'], $action['url'], $color);
    }
}