<?php 

namespace Sypres\Components;

use DateTime;
use WP_Post;
use WP_Term;

class HeadlineArticle {


    public static function createContainer() {
        $posts = get_field('carrousel');
        $article1 = get_field('article_1');
        $article2 = get_field('article_2');
        ?>
        <div class="container-article-headline">
            <div class="title">
                <h2 class="text-white">A la Une</h2>
            </div>
            <div class="columns">
                <div class="column left">
                    <?php Carousel::createStart( 'headline') ?>
                    <?php foreach ($posts as $post): ?>
                        <?php HeadlineArticle::create($post['article']); ?>
                    <?php endforeach; ?>
                    <?php Carousel::createEnd() ?>
                </div>
                <div class="column right">
                    <?php HeadlineArticle::create($article1); ?>
                    <?php HeadlineArticle::create($article2); ?>
                </div>
            </div>
            <div class="headline-bottom">
                <img src="<?= get_stylesheet_directory_uri().'/assets/img/background_headline.webp'; ?>" alt="">
            </div>
        </div>
        <?php  
    }

    public static function create (
        WP_Post $post
    ) {
        $category = get_the_category( $post->ID )[0];
        $img = get_the_post_thumbnail_url($post, 'full');
        $title = strlen($post->post_title) > 38 ?
            ( substr($post->post_title, 0, 38) . "..." ) :
            $post->post_title;
        ?>
            <a class="article-headline text-base" href="<?= $post->guid ?>">
                <img src="<?= $img ?>" class="background-img" alt="">
                <div class="text">
                    <?php Tag::create($category->name) ?>
                    <div class="bottom">
                        <div class="name bold text-xl" href="<?= $post->guid ?>"><?= $title; ?></div>
                        <?php Article::getDetails($post, "white") ?>
                    </div>
                </div>
            </a>
        <?php  
    }

}