<?php

namespace Sypres\Components;

use WP_Post;

class Evenement {
    public static function create(WP_Post $evenement) {
        ?>
        <div class="evenement text-base">
            <div class="img">
                <img src="<?= get_the_post_thumbnail_url($evenement, 'full');  ?>" alt="">
            </div>
            <div class="text">
                <h3><?= $evenement->post_title ?></h3>
                <div class="content"><?= $evenement->post_content ?></div>
            </div>
            <div class="inscription">
                <div class="block">
                    <span>Date: <?= get_field( 'date', 'post_'.$evenement->ID ) ?></span>
                    <span>Horaires: <?= get_field( 'horaire', 'post_'.$evenement->ID ) ?></span>
                    <span>Lieu : <?= get_field( 'lieu', 'post_'.$evenement->ID ) ?></span>
                </div>
                <a href="<?= $evenement->guid ?>">
                    <?php Vignette::create("Inscrivez-vous vite ! ", 'secondary', 'calendar'); ?>
                </a>
            </div>
        </div>
        <?php 
    }
}