<?php 

namespace Sypres\Components;

class Etapes {

    public static function createContainer(
        string $title = "",
        string $text  = "",
        array $etapes = [],
        string $color = "secondary"
    ) {
       
        ?>
            <div class="container-etapes <?= $color ?>">
                <div class="presentation">
                    <h2><?= $title ?></h2>
                    <div class="separator grey"></div>
                    <?php if ($text): ?>
                        <span class="text-xl"><?= $text ?></span>
                    <?php endif; ?>
                </div>
                <!-- TODO: carousel -->
                <div class="group">
                    <?php $index = 1 ?>
                    <?php foreach ($etapes as $etape): ?>
                        <?php Etapes::create(
                            $etape['title'],
                            $etape['text'],
                            $color,
                            $index
                        ); ?>
                        <?php $index++; ?>
                    <?php endforeach; ?>
                </div>
            </div>
        <?php  
    }

    public static function create(
        null|string $title = "",
        null|string $text = "",
        string $color = "",
        int $index = 1
    ) {
        $index_img = ($index + floor( ($index - 1) / 3)) % 3;
        $index_img = $index_img == 0 ? $index_img = 3 : $index_img;
        $img = get_stylesheet_directory_uri().'/assets/img/feuille_'. $index_img .'.webp';
        ?>
            <div class="etapes text-xl">
                <div class="container">
                    <div class="title text-6xl">
                        <span class="number">
                            <?= $index ?>
                        </span>
                        <img src="<?= $img ?>" alt="">
                    </div>
                    <h3 class="name bold"><?= $title ? $title : "" ?></h3>
                    <div class="separator <?= $color ?>"></div>
                    <div class="text"><?= $text ? $text : "" ?></div>
                </div>
            </div>
        <?php  
    }
}