<?php 

namespace Sypres\Components;

use stdClass;

class Ceremonie {

    public static function createContainer(
        string $title = "",
        string $text  = "",
        array $ceremonies = []
    ) {
        $index = 1;
        $colors = [
            "secondary",
            "primary",
            "ternary"
        ];

        ?>
            <div class="container-ceremonie">
                <div class="presentation">
                    <h2><?= $title ?></h2>
                    <div class="separator grey"></div>
                    <span class="text-xl"><?= $text ?></span>
                </div>
                <!-- TODO: carousel -->
                <div class="group">
                    <?php foreach ($ceremonies as $ceremonie): ?>
                        <?php if ( $index == 2 ): ?>
                            <div class="column">
                        <?php endif; ?>
                        <?php 
                        $post = $ceremonie['ceremonie'];
                        $text = get_the_excerpt($post);
                        $text_length = 200;
                        Ceremonie::create(
                            $post->post_title, 
                            strlen($text) > $text_length ? substr( $text, 0, 200) . "..." : $text,
                            $post->guid,
                            get_the_post_thumbnail_url($post, 'full'),
                            $colors[$index-1],
                            $index 
                        );
                         ?>
                        <?php if ($index == 3):  ?>
                            </div>
                        <?php endif ?>
                        <?php $index++; ?>

                    <?php endforeach; ?>
                </div>
            </div>
        <?php  
    }

    public static function create(
        null|string $title = "",
        null|string $text = "",
        null|string $link = "",
        null|string $img = "",
        null|string $color = "primary",
        int $index = 1,
        string $button = "LIRE LA SUITE"
    ) {
        ?>
            <div class="ceremonie text-xl <?= $color ?> <?php $index == 1 ? "first" : "" ?>">
                <div class="img">
                    <img src="<?= $img ?>" alt="">
                </div>
                <div class="container">
                    <span class="name bold"><?= $title ? $title : "" ?></span>
                    <div class="separator <?= $color ? $color : "" ?>"></div>
                    <div class="text"><?= $text ? $text : "" ?></div>
                    <a href="<?= $link ?>" class="btn <?= $color ? $color : "" ?>"><?= $button ?></a>
                </div>
            </div>
        <?php  
    }
}