<?php

namespace Sypres\Components;

class Action {
    public static function createContainer(
        string $title,
        array $button_alt,
        array $button_main,
    ) {
        $index = 1;
        ?>
        <div class="container-action">
            <div class="action text-sm">
                <img src="<?= get_stylesheet_directory_uri().'/assets/img/action_img.webp'; ?>" alt="" class="background-img left">
                <img src="<?= get_stylesheet_directory_uri().'/assets/img/action_img.webp'; ?>" alt="" class="background-img right">
                <div class="container">
                    <span class="text-3xl bold italic"><?= $title ?></span>
                    <div class="row">
                        <?php foreach ($button_alt as $button) {
                            Action::create($button['button']['title'], $button['button']['url'], "");
                        } ?>
                    </div>
                    <div class="row">
                        <?php foreach ($button_main as $button) {
                            Action::create($button['button']['title'], $button['button']['url'], "secondary");
                        } ?>
                    </div>
                        
    
                </div>
            </div>
        </div>
        <?php 
    }

     public static function create (
        string $title,
        string $url,
        string $color
    ) {
        $index = 1;
        ?>
        <a href="<?= $url ?>" class="btn <?= $color ?>"><?= $title ?></a>
        <?php 
    }
}
