<?php 

use Sypres\Api\Brevo;

function get_mails() {
	return ['celine@taketik.fr', 'accueil@sypres.fr', 'olivier.jaupitre@sypres.fr']; //accueil@sypres.fr
}

function get_stripe_public_key() {
	//return 'pk_test_51PApFF07M4Dx3Er7C8Hs6TP4lvxew4PG9ugHvq9oGhMeDOJ0096fJMrMN6EKx0R7SpLrry8OLLPctoTFvyacRd9g00hnL1hTeI';
	return 'pk_live_51PApFF07M4Dx3Er77bFZESe0AIE7cBpRftWpt3EE4LgYAVmMkQEZupUnMCvOhA7Ju7zjQ7PryxvCWutpVFtr1b3u00jKrIzTHH';
}

function get_stripe_secret_key() {
	//return 'sk_test_51PApFF07M4Dx3Er70hEzsH0dryKHGP469XhDBXvjG34Bcu5mY7HQoxmRSDOL0ls0LBliv8aZSmKmXI29f8VEAWAC00KMaSEmKB';
	return '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';
}

add_action('wp_ajax_sypres_get_stripe_api_key', 'sypres_get_stripe_api_key');
add_action('wp_ajax_nopriv_sypres_get_stripe_api_key', 'sypres_get_stripe_api_key');


function sypres_get_stripe_api_key() {
	wp_send_json_success(get_stripe_public_key());
}

add_action('wp_ajax_sypres_client_secret', 'sypres_client_secret');
add_action('wp_ajax_nopriv_sypres_client_secret', 'sypres_client_secret');

function sypres_client_secret() {
	$url = "https://api.stripe.com/v1/payment_intents";
	$data = 'amount=' . $_POST[ 'amount' ] * 50 * 100 . '&'.'currency=' . $_POST[ 'currency' ];

	$headers = array(
		'Content-Type: application/x-www-form-urlencoded',
		'Authorization: Bearer '. get_stripe_secret_key(),
	);

	$ch = curl_init($url);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
	
	$response = curl_exec($ch);
	$res_err_number = !curl_errno($ch);
  	$res_err_message = curl_error($ch);
	
	$response = json_decode($response);
	curl_close($ch);

	if (property_exists($response, 'error')) {
		wp_send_json_success([ "success" => false, "error" => $response->message, "client_secret" => null]);
		return;
	}

	if(!session_id()) {
		session_start();
	}

	$_SESSION["client_secret"] = $response->client_secret;
	$_SESSION["share"] = $_POST[ 'amount' ];
	wp_send_json_success([ "success" => true, "error" => "", "client_secret" => $response->client_secret]);

}

add_action('wp_ajax_sypres_valid_member_payment', 'sypres_valid_member_payment_func');
add_action('wp_ajax_nopriv_sypres_valid_member_payment', 'sypres_valid_member_payment_func');
function sypres_valid_member_payment_func() {
	//TODO: wp_mail("nicolas@taketik.fr", "sypres", $_POST["client_secret"]. "\n" . $_SESSION["client_secret"]);
	
	$categories = explode(',', $_POST["category"]);
	if ($_POST["payment"] === "card") {
		if ($_POST["client_secret"] != $_SESSION["client_secret"]) {
			$message = "Bonjour, une erreur, s'est produite lors du paiement par carte, voici les informations de la personne concernée :";
			send_admin_mail_for_societary($message, "Une erreur est arrivée lors du paiement.");
			wp_send_json_success(['success' => false, 'url' => site_url()]);
		}
		$col_and_list = data_immediate_payment($categories, $_SESSION["share"]);
	}
	else {
		$col_and_list = data_defer_payment($categories, $_POST["share"]);
	}

	$listIds = $col_and_list[0];
	$waiting_payment = $col_and_list[1];
	$share = $col_and_list[2];

	$phone = $_POST["phone"];
	if (substr($phone, 0, 1) === '0'){
		$phone = '0033'. substr($phone, 1);
	}

    $brevo = new Brevo();
	$result = $brevo->getContact($_POST["email"]);

	if ($result["success"] ){
		$blocking_list_id = [59, 60, 61, 62, 63, 66];
		$users_ids = $result["get"]->listIds ?? [];
		$is_user_subscribe = false;
		for ($i = 0; $i < count(value: $users_ids); $i++) {
			if(in_array($users_ids[$i], $blocking_list_id)){
				$is_user_member = true;
			}
		}
		if ( $is_user_member ) {
			$share += $result["get"]->attributes->NOMBRE_DE_PARTS;
			$_POST["payment"] === "card" ? $listIds = [] : $listIds = [67];
			if ( $waiting_payment != "") {
				$strArray = explode(' ', $waiting_payment);
				$waiting_payment = $strArray[0] . ' ' . $strArray[1];
			}
		}	
	}

	if ( $waiting_payment == "" ) {
		$waiting_payment = $result["get"]->attributes->ATTENTE_VALIDATION;
	}

	$data = [
		'email' => $_POST["email"],
		'listIds' => $listIds,
		"updateEnabled" => true,
		'attributes' => array(
			"CIVILITE" => $_POST["civility"],
			"DATE_NAISSANCE" => $_POST["birthday"],
			"NOM"=> $_POST["lastName"],
			"PRENOM"=> $_POST["firstName"],
			"ADRESSE"=> $_POST["address"],
			"CP"=> $_POST["postcode"],
			"VILLE"=> $_POST["city"],
			"TELEPHONE" => $phone,
			"NOMBRE_DE_PARTS" => $share,
			"COMMENTAIRE" => $_POST["comment"],
			"ATTENTE_VALIDATION" => $waiting_payment,
			"OPT_IN" => true
		),
	];

	if ($_POST["isMember"] == "Societaire" || $_POST["payment"] != "card") {
		if ($_POST["isMember"] == "Societaire") {
			$message = "Bonjour, un.e sociétaire a repris des parts sociales, voici ses informations :";
			$subject = "Un.e sociétaire a repris des parts sociales";
		}
		else {
			$message = "Bonjour, un.e sociétaire veut acheter des parts sociales, voici ses informations :";
			$subject = "Un.e sociétaire veut acheter des parts sociales";
		}
		send_admin_mail_for_societary($message, $subject, $listIds, $_POST["payment"] != "card");
	}

	//wp_mail("nicolas@taketik.fr", "sypres", json_encode($result). "\n\n" . json_encode($data));

	$brevo->sendContact($data);

	$url = site_url() . "/merci-pour-votre-demande-de-souscription";

	session_destroy();

	wp_send_json_success(['success' => true, 'url' => $url]);
}

function send_admin_mail_for_societary($message, $subject, $listIds = null, $deferMessage = false) {

    $mails = get_mails();
    $message = $message ."\n".
         "NOM: " . $_POST["civility"]. ' ' . $_POST["lastName"] . ' ' . $_POST["firstName"] . "\n" .
         "DATE DE NAISSANCE: " . $_POST["birthday"]. "\n" .
         "ADRESSE: " . $_POST["address"]. "\n" .
         "CP: " . $_POST["postcode"]. "\n" .
         "VILLE: " . $_POST["city"]. "\n" .
         "TELEPHONE: " . $_POST["phone"] . "\n" .
         "NOMBRE DE PARTS: +" . $_POST["share"]. "\n" .
         "EMAIL: +" . $_POST["email"]. "\n" .
         "COMMENTAIRE: " . $_POST["comment"]. "\n";
    if ($listIds != null) {
        $message .= "LIST: " . json_encode($listIds). "\n" ;
    }

    if ($deferMessage){
        $message .= "Attention, la personne a choisi de payer par virement ou chèque. Ne pas hésiter à le relancer si Syprès n'a rien reçu d'ici quelques jours.\n" .
        "Lorsque les fonds seront reçus, il faudra : \n
            - modifier dans Brévo manuellement le nombre de parts sociales que détient la personne.
            - Ajouter la personne à la liste correspondante
            - Supprimer la mention \"attente validation\"";
    }

    //TODO: remplacer par admin mail
	for ($i = 0; $i < count($mails); $i++) { 
		wp_mail($mails[$i] , $subject, $message);
	}
}

function data_immediate_payment($categories, $share = 0) {
	$listIds = [];
	foreach( $categories as $type ){
		switch($type) {
			case "Salari":
				$listIds[] = 62;
				break;
			case "Famille":
				$listIds[] = 59;
				break;
			case "Soutien":
				$listIds[] = 63;
				break;
			case "Collectivit territoriale":
				$listIds[] = 66;
				break;
			case "Partenaire pers morale":
				$listIds[] = 60;
				break;
			case "Prestataire contrat fourniture":
				$listIds[] = 61;
				break;
		}
	}
	return [$listIds, "", $share];
}

function data_defer_payment($categories, $share) {
	$listIds = [67];
	$waiting_payment = "Parts: ". $share. " - ";
	foreach( $categories as $type ){
		switch($type) {
			case "Salari":
				$waiting_payment .= "SALARIE:62";
				break;
			case "Famille":
				$waiting_payment .= "FAMILLE:59";
				break;
			case "Soutien":
				$waiting_payment .= "SOUTIEN:63";
				break;
			case "Collectivit territoriale":
				$waiting_payment .= "COLLERTIVITE:66";
				break;
			case "Partenaire pers morale":
				$waiting_payment .= "PART_PERS_MORALE:60";
				break;
			case "Prestataire contrat fourniture":
				$waiting_payment .= "CONTRAT_FOURNITURE:61";
				break;
		}
		$waiting_payment .= " - ";
	}
	$waiting_payment = substr($waiting_payment, 0, -3);
	return [$listIds, $waiting_payment, 0];
}