<?php 

use Sypres\Post\Evenement;
use Sypres\Post\Post;

add_action('save_post', 'sypres_save_article', 10, 3);

function sypres_save_article($post_id, $post, $update) {

    // Prevent infinite loops & autosaves
    if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return;
    if ( wp_is_post_revision( $post_id ) ) return;

    if ( $post->post_type == 'evenement' ) {
        Evenement::new($post_id, $post );
    } 

    if ( $post->post_type == 'post' || $post->post_type == 'evenement' ) {
        Post::save($post_id, $post);
    };
}

function sypres_get_month($month) {
    $monthNames = array(
        "01" => 'Jan',
        "02" => 'Fév',
        "03" => 'Mars',
        "04" => 'Avril',
        "05" => 'Mai',
        "06" => 'Juin',
        "07" => 'Juil',
        "08" => 'Août',
        "09" => 'Sept',
        "10" => 'Octo',
        "11" => 'Nov',
        "12" => 'Déc'
    );
	return $monthNames[$month];
}