document.addEventListener('DOMContentLoaded', function () {
    initFaq();
    initFaqCloseButton();
    initNav();
    scrollFromTop();
    initCarousel();
});

function initFaq() {
    let questions = document.querySelectorAll('.faq .question');
    for (let i = 0; i < questions.length; i++) {
        questions[i].addEventListener('click', function (e) {
            let question = e.target;
            while ( !question.classList.contains('question')) {
                question = question.parentElement;
            }

            let response = question.parentElement.querySelector('.response');
            response.style.maxHeight = response.scrollHeight;

            if (question.classList.contains('open') ) {
                response.classList.add('close');
                question.classList.remove('open');
            }
            else {
                response.classList.remove('close');
                question.classList.add('open');
            }
        })
    }
}

function initFaqCloseButton() {
    if ( !document.getElementById('faq-close-button') ) { return; }
    document.getElementById('faq-close-button').addEventListener('click', () => {
        let questions = document.querySelectorAll('.faq .container[data-closable="1"]');
        if ( questions.length == 0 ) { return; }
        if (questions[0].classList.contains('hidden')) {
            for (let i = 0; i < questions.length; i++) {
                questions[i].classList.remove('hidden');
            }
            document.getElementById('faq-close-button').innerHTML = "Fermer";
        }
        else {
            for (let i = 0; i < questions.length; i++) {
                questions[i].classList.add('hidden');
            }
            document.getElementById('faq-close-button').innerHTML = "TOUT VOIR";
        }
    });
}

function initNav() {
    let items = document.querySelectorAll('.nav-menu.desktop .container');
    for (let i = 0; i < items.length; i++) {
        if ( !document.querySelector('.nav-menu.desktop [data-window="'+ (i + 1) +'"]')) { continue; }
        
        items[i].addEventListener('mouseover', function (e) {
            let item = e.target;
            while ( !item.classList.contains('container')) {
                item = item.parentElement;
            }

            let win = document.querySelector('.nav-menu.desktop [data-window="'+ item.dataset.menu +'"]');
            if (win) win.classList.remove('hidden');
        });

        items[i].addEventListener('mouseout', function (e) {
            let item = e.target;
            while ( !item.classList.contains('container')) {
                item = item.parentElement;
            }

            let win = document.querySelector('.nav-menu.desktop [data-window="'+ item.dataset.menu +'"]');
            if (win) win.classList.add('hidden');
        });
    }

    items = document.querySelectorAll('.window-mobile .container');
    for (let i = 0; i < items.length; i++) {
        if ( !document.querySelector('.window-mobile [data-window="'+ (i + 1) +'"]')) { continue; }
        
        items[i].addEventListener('click', function (e) {
            let item = e.target;
            while ( !item.classList.contains('container')) {
                item = item.parentElement;
            }

            let win = document.querySelector('.window-mobile [data-window="'+ item.dataset.menu +'"]');
            
            if ( !win ) { return; }
            win.classList.contains('hidden') ? 
                win.classList.remove('hidden') :
                win.classList.add('hidden');
        });
    }

    document.querySelector('.nav-open').addEventListener('click', function () {
        document.querySelector('.nav-open').classList.add('hidden');
        document.querySelector('.nav-close').classList.remove('hidden');
        document.querySelector('.window-mobile').classList.remove('hidden');
    });

    document.querySelector('.nav-close').addEventListener('click', function () {
        document.querySelector('.nav-open').classList.remove('hidden');
        document.querySelector('.nav-close').classList.add('hidden');
        document.querySelector('.window-mobile').classList.add('hidden');
    });



}

function scrollFromTop() {
    window.addEventListener('scroll', function() {
        if (window.scrollY > 0) {
            document.querySelector('header').classList.add('scrolled');
        } else {
            document.querySelector('header').classList.remove('scrolled');
        }
    });
}

function initCarousel() {
    let carousels = document.querySelectorAll(".slides");
    for (let i = 0; i < carousels.length; i++) {

        function showSlide(slides) {
            const length = slides.children[0].offsetWidth + 24;
            let translation = length * slides.dataset.index + 10;
            translation = translation < 0 ? 0 : translation;
            slides.style.transform = "translateX(-" + translation + "px)";
        }

        carousels[i].parentElement.querySelector('.next-slide').addEventListener('click', (e) => {
            let slides = getCarouselParent(e);
            let index = slides.dataset.index;
            let actualTotal = slides.children.length - 1 - correctionIndexByOffset(slides);
            index = index == 0 ? 
                actualTotal :
                parseInt(index) - 1;
            slides.dataset.index = index;
            showSlide(slides);
        });

        carousels[i].parentElement.querySelector('.preview-slide').addEventListener('click', (e) => {
            let slides = getCarouselParent(e);
            let index = slides.dataset.index;
            let actualTotal = slides.children.length  - 1 - correctionIndexByOffset(slides);
            index = index == actualTotal ? 
                0 :
                parseInt(index) + 1;
            slides.dataset.index = index;
            showSlide(slides);
        });

        showSlide(carousels[i]);
    }

}

function correctionIndexByOffset( slides ) {
    offsetIndex = Math.floor( slides.parentElement.offsetWidth / slides.children[0].offsetWidth );
    return offsetIndex == 0 ? offsetIndex : offsetIndex - 1;
}

function getCarouselParent( event ) {
    let slides = event.target;
    while ( !slides.classList.contains('carousel') ) {
        slides = slides.parentElement;
    }
    return slides.querySelector('.slides');
}

