<?php
function getTemplateMap() {
?>
    <div class="map-container">
        <div class="map-block">
            <img src="<?= getInteractiveMapPath() ?>/src/Carte_de_France.png" alt="" class="map-img">
            <div class="button-block">
                <?php $length = getNumbersOfPoint();
                for ($i=0; $i < $length * $length; $i++) :?>
                    <button onclick="showPoint(<?=$i ?>)" class="map-button"></button>
                <?php endfor ?>
            </div>
           
        </div>
        <span id="displayer"></span>
    </div>
    <style>
        .map-container {
            width: 100%;
            padding: 10px; 
            background: #f9f9f9; 
            margin-top: 20px;
            margin-bottom: 20px;
            float: left;
            display: flex;
            align-items: center;
            justify-content: center;
            position: relative;
            flex-direction: column;
        }

        .map-block {
            width: 50%;
            min-width: 300px;
            position: relative;
        }

        .map-img {
            width: 100%;
        }

        .button-block {
            position: absolute;
            top: 0;
            right: 0;
            width: 100%;
            height: 100%;
            display: flex;
            flex-wrap: wrap;
            z-index: 100;
        }

        .map-button {
            padding: 0;
            background-color: transparent;
            border: 1px black solid;
            width: <?= 100/$length ?>%;
            height: <?= 100/$length ?>%;
            cursor: pointer;
        }

        #displayer {
            margin-top: 10px;
            font-size: 25px;
        }
    </style>
    <script>
        function showPoint(int) {
            document.getElementById('displayer').innerHTML = 'X: ' + int % <?= $length ?> + ' | Y: ' + Math.floor(int / <?= $length ?>) ;

        }
    </script>
<?php  
} 