<?php
/*
 * Page bulletin part social
 * Template Name: part social
 * 
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 * 
 * @package WordPress
 * @subpackage Sypres
 * @since Sypres 1.0
 */
?>
<?php get_header();?>

<div class="main template part-social">
    <?php the_content(); ?>
    <div class="section">
        <h2 class="text-primary primary">Devenez Sociétaire Syprès</h2>
        <span class="text-base">Les champs marqués d’un <span class="text-red">*</span> sont obligatoires</span>
        <form id="form-social-share" action="" class="text-base" action="<?= admin_url( 'admin-ajax.php' ); ?>" data-listener="none">
            <span class="mt-20 text-xl bold text-grey">Civilité <span class="text-red">*</span></span>
            <div class="row choices civilite">
                <input type="radio" name="civilite" id="Mme" value="Mme" required>
                <Label for="Mme">Mme.</Label>
                <input type="radio" name="civilite" id="M"  value="M" required>
                <Label for="M">M.</Label>
            </div>
          
            <div class="row">
                <div class="container-movable">
                    <Label class="movable" for="lastname">Nom <span class="text-red">*</span></Label>
                    <input type="text" name="lastname" id="lastname" required>
                </div>
 
                <div class="container-movable">
                    <Label class="movable" for="firstname">Prénom <span class="text-red">*</span></Label>
                    <input type="text" name="firstname" id="firstname" required>
                </div>
            </div>

            <div class="column">
                <Label for="birthday">Date de Naissance <span class="text-red">*</span></Label>
                <input type="date" name="birthday" id="birthday" required>
            </div>

            <div class="row">
                <div class="container-movable">
                    <Label class="movable" for="address">Adresse <span class="text-red">*</span></Label>
                    <input type="text" name="address" id="address" required>
                </div>
            </div>

            <div class="row">
                <div class="container-movable">
                    <Label class="movable" for="postcode">Code Postal <span class="text-red">*</span></Label>
                    <input type="text" name="postcode" id="postcode" required>
                </div>

                <div class="container-movable">
                    <Label class="movable" for="city">Commune <span class="text-red">*</span></Label>
                    <input type="text" name="city" id="city" required>
                </div>
            </div>

            <div class="row">
                <div class="container-movable">
                    <Label class="movable" for="email">Courriel <span class="text-red">*</span></Label>
                    <input type="email" name="email" id="email" required>
                </div>
                <div class="container-movable">
                    <Label class="movable" for="phone">Téléphone <span class="text-red">*</span></Label>
                    <input type="tel" name="phone" id="phone" required>
                </div>
            </div>

            <span class="mt-20 text-xl text-grey">Je déclare :  <span class="text-red">*</span></span>
            <div class="row choices">
                <div>
                    <input type="radio" name="isMember" id="no-societaire" value="Pas encore societaire" required>
                    <Label for="no-societaire">Vouloir devenir sociétaire de la Société Coopérative d’Intérêt Collectif Syprès</Label>
                </div>

                <div>
                    <input type="radio" name="isMember" id="societaire"  value="Societaire" required>
                    <Label for="societaire">Être déjà sociétaire et vouloir souscrire à nouveau au capital, en acquérant de nouvelles parts de la Société Coopérative d’Intérêt Collectif Syprès</Label>
                </div>
            </div>

            <span class="mt-20 text-xl text-grey">Si ma demande est acceptée, j’intégrerai l’une des catégories de sociétaires définies par les statuts de la coopérative.</span>
            <div class="row choices category">
                <div >
                    <input type="radio" name="category" id="Salari" value="Salari" required>
                    <Label for="Salari">Salarié.e</Label>
                </div>

                <div>
                    <input type="radio" name="category" id="Famille"  value="Famille" required>
                    <Label for="Famille">Famille</Label>
                </div>

                <div>
                    <input type="radio" name="category" id="Soutien"  value="Soutien" required>
                    <Label for="Soutien">Soutien</Label>
                </div>

                <div>
                    <input type="radio" name="category" id="Collectivit"  value="Collectivit territoriale" required>
                    <Label for="Collectivit">Collectivité territoriale</Label>
                </div>

                <div>
                    <input type="radio" name="category" id="morale"  value="Partenaire pers morale" required>
                    <Label for="morale">Partenaire (pers. morale engagé par une convention)</Label>
                </div>

                <div>
                    <input type="radio" name="category" id="Prestataire"  value="Prestataire contrat fourniture" required>
                    <Label for="Prestataire">Prestataire (contrat de fourniture biens ou services)</Label>
                </div>
            </div>

            <div class="row">
                <div class="container-movable">
                    <Label class="movable" for="comment">Comment avez-vous connu Syprès ?</Label>
                    <textarea name="comment" id="comment" class="text-base"></textarea>
                </div>
            </div>

            <span class="mt-20 text-xl text-grey">Nombre de parts <span class="text-red">*</span></span>
            <div class="row part-social text-xl">
                <input type="number" name="share" id="share" min="1" required>
                <span>X 50€ = <span id="numberOfPartTotal" class="text-primary bold"></span>€</span>
            </div>

            <div class="row">
                <input type="checkbox" name="convocation" id="convocation" required>
                <label for="convocation" >
                    J’accepte d’être convoqué(e) aux assemblées par courrier électronique que la coopérative funéraire Syprès ait recours à la transmission par voie électronique en lieu et place de l’envoi postal lors de l’exécution des formalités de convocation, d’envoi de documents d’informations et de vote à distance et plus généralement d’être destinataire d’informations et decommunications institutionnelles de la part de ma coopérative. Cette autorisation a comme seul objectif de faciliter la gestion de Syprès : limiter les frais de gestion et économiser le papier. <span class="text-red">*</span>
                </label>
            </div>

            <div class="row">
                <input type="checkbox" name="status" id="status" required>
                <label for="status">
                    Je reconnais avoir pris connaissance des statuts de Syprès - SCIC SAS à capital variable, et dont le siège social est situé au 57 Bd Franklin Roosevelt à Talence (33400). Les statuts peuvent être communiqués sur simple demande ou bien consultés directement sur le site : sypres.fr. <span class="text-red">*</span>
                </label>
            </div>

            <button class="btn primary mt-20 text-xl">
                Je confirme ma volonté de devenir sociétaire de la coopérative funéraire Syprès
            </button>

            <div id="payment-windows" class="hidden">
                <span class="title">Total: <span id="numberOfPartTotalPaiement"></span>€</span>
                <div id="card">
                    <div class="payment-container"> 
                        <input id="payment_method_stripe" type="radio" class="payment-radio" name="payment_method" value="card" >
                        <label for="payment_method_stripe">Carte bancaire</label>
                        <span class="img-container">
                            <img class="icon" src="<?= get_stylesheet_directory_uri().'/assets/img/visa.svg'; ?>"></img>
                            <img class="icon" src="<?= get_stylesheet_directory_uri().'/assets/img/mastercard.svg'; ?>"></img>
                        </span>
                    </div>
                    <div id="payment-form" class="hidden">
                        <div id='card-element'></div>
                        <div id='payment-messages' role="alert"></div>
                    </div>
                </div>
                <div id="cheque">
                    <div class="payment-container"> 
                        <input id="payment_method_cheque" type="radio" class="payment-radio" name="payment_method" value="cheque" >
                        <label for="payment_method_cheque">Chèque envoyé ce jour à l’ordre de la SCIC SYPRÈS</label>
                        <span class="img-container"></span>
                    </div>
                </div>
                <div id="transfer">
                    <div class="payment-container"> 
                        <input id="payment_method_transfer" type="radio" class="payment-radio" name="payment_method" value="transfer" >
                        <label for="payment_method_transfer">Virement au compte de la SCIC SYPRÈS --- IBAN : FR76 1444 5004 0008 0057 8890 672 (Pensez à indiquer votre Nom et Prénom dans le motif de paiement)</label>
                        <span class="img-container"></span>
                    </div>
                </div>
                <div class="payment-button-container">
                    <button id="submit-stripe" class="hidden">Payer</button>
                    <button id="submit-defer-payment" class="hidden">Envoyer la demande</button>
                    <span class="loader hidden" id="payment_loader"></span>
                </div>
            </div>
        </form>
    </div>
</div>

<?php get_footer() ?>