<?php

namespace Sypres\Utils;

class Email {

    public static function getHeaders() {
        return ['Content-Type: text/html; charset=UTF-8', 'From: Syprès <no-reply@sypres.coop>'];
    }

    public static function send( string|array $to, $subject, $message) {

        if (gettype($to) == 'string') {
            $to = [$to];
        }

        foreach ($to as $email) {
            wp_mail(
                $email, 
                $subject, 
                $message, 
                Email::getHeaders()
            );
        }
    }

    public static function getTemplateDevis($data) {
        $message = $data['prenom']." ".$data['nom']." vient de vous envoyer une demande de devis !\n";

        if ( $data['situation'] == "decede" ) {
            $message .= "Il s'agit d'un décès avéré survenu à ";
        }
        else if ( $data['situation'] == "imminent" ) {
            $message .= "Il s'agit d'une fin de vie imminente à ";

        }
        else if ( $data['situation'] == "autre" ) {
            $message .= "Il s'agit d'une situation particulière qui pourrait avoir lieu à ";
            
        }

        $message .= $data['communeDeces']." ";

        if ( $data['lieu'] == "hopital" ) {
            $message .= "dans un Ehpad";
        }
        else if ( $data['lieu'] == "ehpad" ) {
            $message .= "dans un hôpital";

        }
        else if ( $data['lieu'] == "domicile" ) {
            $message .= "à domicile";
        }
        $message .= ".\n\n";

        if ($data['type'] == 'inhumation') {
            $message .= "Le demandeur souhaite une inhumation à (ville). Il s'agira d'une concession (en caveau / en pleine terre).";
            $message .= $data['communeInhumation'].". ";
            $message .= "Il s'agira d'une concession (en caveau / en pleine terre).";
            if ($data['concession'] == "caveau") {
                $message .= "en caveau";
            }
            else if ($data['concession'] == "terre") {
                $message .= "en pleine terre";
            }
        }
        else if ($data['type'] == 'cremation') {
            $message .= "Le demandeur souhaite une crémation au ".$data['crematorium'].".\n";
            $message .= "Les cendres seront ";
            switch ($data['destination']) {
                case "nature":
                    $message .= "dispersées en pleine nature";
                    break;
                case "mer":
                    $message .= "dispersées en mer";
                    break;
                case "inhumationCaveau":
                    $message .= "inhumées au sein de l'urne à l'intérieur du caveau";
                    break;
                case "sellementCaveau":
                    $message .= "scellées sur le caveau à l'intérieur de l'urne";
                    break;
                case "columbarium":
                    $message .= "inhumées dans l'urne au sein d'un cavurne ou d'un colombarium";
                    break;
            }
        }
        $message .= ".\n\n";

        $message .= "Cette personne a spécifié le.s point.s suivant.s : ".$data['comment'];
        $message .= ".\n\n";
        $message .= "Vous pouvez le joindre le demandeur ";
        $message .= ($data['phone'] && $data['phone'] != "") ? "au ".$data['phone']." ou" : "";
        $message .= "sur sa boîte mail ".$data['email'];
        $message .= ".\n\n";

        return $message;
    }
}