<?php

namespace Sypres\Post;

use Sypres\Enum\ThematicName;

class Thematic {

    /**
     * Summary of getPosts
     * @param mixed $thematic
     * @param array $search { numberposts, orderby, order }
     * @return array<int|\WP_Post>
     */
    public static function getPosts( $thematic, array $search = [] ) {
        if ( $thematic['name'] == ThematicName::EVENT->value ) {
            return Thematic::getEvenementPosts( $search );
        }
        return Thematic::getCategoryPosts($thematic, $search);
    }

    private static function getCategoryPosts( $thematic, $search ) {
        $latest_posts = get_posts([
            'numberposts'      => key_exists('numberposts', $search) ? $search['numberposts'] : 2,
            'category'         => $thematic['ID'],
            'orderby'          => 'date',
            'order'            => 'DESC',
            'meta_key'         => '',
            'meta_value'       => '',
            'post_type'        => 'post',
        ]);
        return $latest_posts;
    }

    private static function getEvenementPosts( $search ) {
        $latest_posts = get_posts([
            'numberposts'      => key_exists('numberposts', $search) ? $search['numberposts'] : 2,
            'orderby'          => 'meta_value',
            'order'            => 'DESC',
            'meta_key'         => 'date',
            'post_type'        => 'evenement',
        ]);
        return $latest_posts;
    }

    public static function get( string $search ) {

        if ( $search == ThematicName::EVENT->value ) {
            return Thematic::getEvenement();
        }

        $categories = get_terms([
            'taxonomy'   => 'category',
            'hide_empty' => false,
        ]);

        foreach ($categories as $category) {
            if ( property_exists($category, 'name') && $category->name == $search ) {
                return Thematic::getFromCategory($category);
            }
        }
    }

    public static function getAll() {

        $categories = get_terms([
            'taxonomy'   => 'category',
            'hide_empty' => false,
        ]);

        $thematics = [];
        foreach ($categories as $category) {
            $thematics[] = Thematic::getFromCategory($category);
        }

        $thematics[] = Thematic::getEvenement();

        return $thematics;
    }

    private static function getFromCategory($category) {
        $thematic = []; 
        $thematic['name'] = $category->name;
        $thematic['ID'] = $category->term_id;
        $thematic['color'] = get_field( 'color_selector', 'category_'.$category->term_id );
        $thematic['img'] = get_field( 'image', 'category_'.$category->term_id);
        return $thematic;
    }

    private static function getEvenement() {
        $thematic = []; 
        $thematic['name'] = ThematicName::EVENT->value;
        $thematic['ID'] = null;
        $thematic['color'] = get_field( 'color_selector', 'option' );
        $thematic['img'] = get_field( 'image', 'option');
        return $thematic;
    }
}