<?php

namespace Sypres\Post;

use Sypres\Api\Brevo;

class Evenement {

    public static function orderBy( $query ) {
        if ( 
            !is_admin() || 
            !$query->is_main_query() || 
            !isset($_GET['post_type']) || 
            $_GET['post_type'] != 'evenement'
        ) {
            return;
        }

        global $pagenow;
        if ( is_admin() && 'edit.php' == $pagenow && !isset($_GET['orderby'])) {
            $query->set( 'orderby', 'event_date' );
            $query->set( 'order', 'DESC' );
        }   

        if ( $query->get( 'orderby') === 'event_date' ) {
            $query->set( 'orderby', 'meta_value' );
            $query->set( 'meta_key', 'date' );
        }
    }

    public static function sortableColumns( $columns ) {
        $columns['event_date'] = "event_date";
        return $columns;
    }

    public static function hydrateColumn( $column, $post_id ) {
        // Image column
        if ( $column === 'event_date' ) {
            echo get_field('date');
        }
    }

    public static function orderColumns( $post_columns ) {
        $new_columns = [];
        $new_columns['cb'] =  $post_columns['cb'];
        $new_columns['title'] =  $post_columns['title'];
        $new_columns['event_date'] = "Date de l'événement";
        //$new_columns['author'] =  $post_columns['author'];
        $new_columns['date'] =  $post_columns['date'];
        return $new_columns;
        
    }

    public static function new( $post_id, $event ) {
        $META_KEY = "isCreated";
        if ( !metadata_exists( 'post', $post_id,  $META_KEY ) ) {
            add_post_meta( $post_id,  $META_KEY, 0, true );
        }
        else if ( get_metadata('post', $post_id,  $META_KEY)[0] == "0" ) {
            $brevo = new Brevo();
            $brevo->createList($event);
            update_post_meta( $post_id,  $META_KEY, 1 );
        }
    }

    public static function init() {
        $labels = array(
            'name'                => _x( 'Evénement', 'Post Type General Name'),
            'singular_name'       => _x( 'Evénement', 'Post Type Singular Name'),
            'menu_name'           => __( 'Evénement'),
            'all_items'           => __( 'Evénements'),
            'view_item'           => __( 'Voir les événements'),
            'add_new_item'        => __( 'Ajouter un événement'),
            'add_new'             => __( 'Ajouter'),
            'edit_item'           => __( 'Editer un événement'),
            'update_item'         => __( 'Modifier un événement'),
            'search_items'        => __( 'Rechercher un événement'),
            'not_found'           => __( 'Non trouvée'),
            'not_found_in_trash'  => __( 'Non trouvée dans la corbeille'),
        );
        
        $args = array(
            'label'               => __( 'Evénements'),
            'description'         => __( 'Tous les événements'),
            'labels'              => $labels,
            'menu_icon'           => 'dashicons-calendar',

            'supports'            => array( 'title', 'editor', 'author', 'thumbnail', 'revisions', 'custom-fields' ),

            'show_in_rest'        => false,
            'hierarchical'        => false,
            'public'              => true,
            'has_archive'         => true,
            'rewrite'			  => array( 'slug' => 'evenement'),

        );
        
        register_post_type( 'evenement', $args );
    }
}
