<?php

namespace Sypres\Navigation;

class Navbar {

    public static function create() {
        $menu_items = wp_get_nav_menu_items('Menu Principal');

        $nav = [];
        foreach ($menu_items as $item) {
            if ( $item->menu_item_parent == 0 ) {
                $nav[$item->ID] = $item;
                $nav[$item->ID]->children = [];
            }
            else {
                $nav[$item->menu_item_parent]->children[] = $item;
            }
        }

        $index = 1;

        ?>
            <div class="navbar">
                <a class="logo" href="<?= home_url() ?>">
                    <img src="<?= get_stylesheet_directory_uri().'/assets/img/logo.webp'; ?>" alt="">
                </a>
                <div class="nav-menu desktop">
                    <?php foreach ($nav as $item): ?>
                        <?php $hasChildren = count($item->children) > 0 ?>
                        <div class="container" data-menu="<?= $index ?>">
                            <?php Navbar::getMenuItem($item, true, $hasChildren) ?>

                            <?php if ( $hasChildren ): ?>
                            <div class="window hidden" data-window="<?= $index ?>">
                                <?php foreach ($item->children as $child): ?>
                                    <?php Navbar::getMenuItem($child) ?>
                                <?php endforeach; ?>
                            </div>
                            <?php endif; ?>
                        </div>
                        <?php $index++; ?>
                    <?php endforeach; ?>
                </div>
                <div class="nav-menu mobile">
                    <img class="nav-open" src="<?= get_stylesheet_directory_uri().'/assets/img/icon/menu_open.svg'; ?>" alt="">
                    <img class="nav-close hidden" src="<?= get_stylesheet_directory_uri().'/assets/img/icon/menu_close.svg'; ?>" alt="">
                </div>
            </div>
            <div class="window-mobile hidden">
                <?php $index = 1; ?>
                <?php foreach ($nav as $item): ?>
                    <?php $hasChildren = count($item->children) > 0 ?>
                    <div class="container" data-menu="<?= $index ?>">
                        <?php Navbar::getMenuItem($item, !$hasChildren, $hasChildren) ?>

                        <?php if ( $hasChildren ): ?>
                        <div class="window hidden" data-window="<?= $index ?>">
                            <?php foreach ($item->children as $child): ?>
                                <?php Navbar::getMenuItem($child) ?>
                            <?php endforeach; ?>
                        </div>
                        <?php endif; ?>
                    </div>
                    <?php $index++; ?>
                <?php endforeach; ?>
            </div>
        <?php  
    }

    public static function getMenuItem($item, $hasLink = true, $hasArrow = false) {
        $fields = get_fields($item->ID);
    ?>
        <?php if (!$hasLink || $fields['no_link']):?>
            <div class="item">
                <span>
                    <?= $item->title ?>
                </span>
                <?php if ( $hasArrow ):?>
                    <div class="arrow"></div>
                <?php endif; ?>
            </div>
        <?php else: ?>
            <a class="item" href="<?= $item->url ?>" >
                <span>
                    <?= $item->title ?>
                </span>
                <?php if ( $hasArrow ):?>
                    <div class="arrow"></div>
                <?php endif; ?>
            </a>
        <?php endif; ?>
     <?php 
    }

    public static function createSecondMenu() {
        ?>
        <div class="second-menu text-base">
            <span>Ouverture du lundi au vendredi de 9h à 17h - En cas de décès nous sommes disponibles 7/7 j et 8h/20h par téléphone</span>
        </div>
        <?php  
    }
}