<?php 

namespace Sypres\Components;

class ValueGradient {

    public static function createContainer(
        array $boxes
    ) {
        $index = 1;
         ?>
            <div class="container-value">
                <?php foreach ($boxes as $box): ?>
                    <?php ValueGradient::create(
                        $box['title'], 
                        $box['text'],
                        $box['link'],
                        $box['color'] ?? "secondary",
                        $index,
                        $box['button'] ?? "EN SAVOIR PLUS",
                        $box['target'] ?? ""
                    ); ?>
                    <?php $index++; ?>
                <?php endforeach; ?>
            </div>
        <?php 
    }

    public static function create(
        string $title, 
        string $text, 
        string $lien,
        null|string $color = "secondary",
        int $index = 1, 
        string $button = "EN SAVOIR PLUS",
        string $target = ""
    ) {
        if (!$color) { $color = "secondary"; }
        $color_gradient =  match ($index) {
            1 => $color."-600",
            2 => $color."-500",
            3 => $color."-400",
            default => $color."-600"
        };
        ?>
            <div class="value gradient <?= $color_gradient ?> text-base">
                <div class="text">
                    <h3><?= $title ?></h3>
                    <p><?= $text ?></p>
                    <a href="<?= $lien ?>" target="<?= $target ?>" class="btn <?= $color ?>"><?= $button ?></a>
                </div>
                <div class="img"></div>
            </div>
        <?php
    }
}

