<?php

namespace Sypres\Components;

class Perimetre {
    public static function create(string $title, string $text, array $etablissements) {
        ?>
        <div class="perimetre">
            <div class="column left text-white">
                <h2><?= $title ?></h2>
                <div class="text-xl">
                    <?= $text ?>
                </div>
                <div class="etablissement">
                    <?php foreach ($etablissements as $etablissement): ?>
                        <a class="text-sm" href="<?= $etablissement['link']['url'] ?>" target="_blank"><?= $etablissement['link']['title'] ?></a>
                    <?php endforeach; ?>
                </div>
            </div>
            <div class="column right">
                <img src="<?= get_stylesheet_directory_uri().'/assets/img/map.webp'; ?>" alt="">
            </div>

        </div>
        <?php 
    }
}