<?php

namespace Sypres\Components;

class Paragraph {
    public static function create(
        string $type = 'simple',
        $title = "",
        string $text = "", 
        string $color = null,
        $img = null,
        $orientation = "left",
        $action =  [],
        $font_size = null
    ) {

        if ( $font_size == null || $font_size == "" ) {
           $font_size = ($title && strlen($title) != 0 ) ? "text-base" : "";
        }
        ?>
            <?php if ( $type == 'simple'): ?>
                <div class="paragraph <?= $color ? $color : "" ?>">
                    <?php Paragraph::getTitle($title)?>
                    <div class="content <?= $font_size ?>"><?= $text ?></div>
                    <?php Paragraph::getAction($action, $color) ?>
                </div>
            <?php elseif ( $type == 'background'): ?>
                <div class="paragraph background">
                    <div class="container <?= $color ? $color : "" ?>">
                        <?php Paragraph::getTitle($title)?>
                        <div class="<?= $font_size ?>"><?= $text ?></div>
                        <?php Paragraph::getAction($action, $color) ?>
                    </div>
                </div>
            <?php elseif ( $type == 'side' ): ?>
                <div class="paragraph side <?= $orientation ?>">
                    <img src="<?= $img['url'] ?>" alt="">
                    <div class="container <?= $color ? $color : "" ?>">
                        <?php Paragraph::getTitle($title)?>
                        <div class="<?= $font_size ?>"><?= $text ?></div>
                        <?php Paragraph::getAction($action, $color) ?>
                    </div>
                </div>
            <?php endif; ?>
        <?php 
    }

    public static function getTitle( $title, $color = null ) {
        if ( !$title ) { return; }
        ?>
            <h2 class="<?= $color ? $color : "grey" ?>"><?= $title ?></h2>
        <?php  
    }

    public static function getAction($action = [], $color = null ) {
        if ( !$action || count($action) == 0 ) { return; }
        Action::create($action['title'], $action['url'], $color);
    }
}