<?php

namespace Sypres\Components;

use Sypres\Api\Brevo;

class Newsletter {

    private const NOUNCE = "sypres_newsletter";
    
    public static function create() {

        $EVENT = 'register_contact_newsletter';
        ?>
        <div class="newsletter">
            <form class="form">
                <input type="hidden" name="nonce"value="<?php echo wp_create_nonce( Newsletter::NOUNCE ); ?>" >
                <div class="information success hidden">
                    Votre inscription a été correctement effectuée
                </div>
                <div class="information echec hidden">
                    Une erreur s'est produite
                </div>
                <input type="hidden" name="action" value="<?= $EVENT ?>">
                <h3 class="text-3xl">S’inscrire à la Newsletter</h3>
                <span class="text-xl">Recevez l’actualité de la coopérative</span>
                <div class="inputs">
                    <div class="row">
                        <input type="text" name="PRENOM" placeholder="Prénom">
                        <input type="text" name="NOM" placeholder="Nom">
                    </div>
                    <input type="email" name="EMAIL" placeholder="Email">
                </div>
                <button class="btn secondary">S’INSCRIRE</button>
            </form>
            <div class="img">
                <img src="<?= get_stylesheet_directory_uri().'/assets/img/newsletter.webp'; ?>" alt="">
            </div>
        </div>
       
        <?php 
    }

    public static function register() {
        if( 
            ! isset( $_REQUEST['nonce'] ) or 
            ! wp_verify_nonce( $_REQUEST['nonce'], Newsletter::NOUNCE ) 
        ) {
            wp_send_json_error( "Vous n’avez pas l’autorisation d’effectuer cette action.", 403 );
        }
        $data = [
            'email' => $_POST["EMAIL"],
            'listIds' => [65],
            "updateEnabled" => true,
            'attributes' => $_POST
        ];

        $brevo = new Brevo();
        $result = $brevo->sendContact($data);
        $response = [ 'success' => $result['success'] ];
        wp_send_json_success($response);
    }
}