<?php

namespace Sypres\Components;

use Sypres\Post\Thematic;

class Faq {

    public static function create(array $rows, $thematic = null, $title = null) {
        $index = 1;
        $color = key_exists('color', $thematic ?? []) ? $thematic['color'] : "";
        ?>
        <div class="faq <?= $color ?>">
            <?php if ($thematic): ?>
                <?php  $img = get_stylesheet_directory_uri().
                    '/assets/img/icon/'.
                    $thematic['img'].'.svg'; ?>
                <span class="title bold"><img src="<?= $img ?>" alt="" class="<?= $color ?>"> <?= $thematic['name'] ?></span>
            <?php elseif ($title): ?>
                <span class="bold"><?= $title ?></span>
            <?php endif; ?>
            <?php $index = 0; ?>
            <?php foreach ($rows as $row): ?>
                <div class="container <?= $index >= 4 ? "hidden" : "" ?>" data-closable="<?= $index >= 4 ? 1 : 0 ?>">
                    <div class="row text-base">
                        <div class="question bold" data-question="<?= $index ?>">
                            <div class="icon <?= $color ? $color : "" ?>"></div>
                            <span><?= $row['question'] ?></span>
                        </div>
                        <div class="response close" data-response="<?= $index ?>">
                            <?= $row['response'] ?>
                        </div>
                    </div>
                </div>
            <?php $index++; ?>
            <?php endforeach; ?>
        </div>
        <?php 
    }

    public static function createGeneric() {
        $faqs = get_field('faq_generic', 'option');
        foreach ($faqs as $faq) {
            $thematic  = Thematic::get($faq['thematic_selector']);
            Faq::create($faq['lignes'], $thematic);
        }
         ?>
            <button id="faq-close-button" class="btn grey text-base">
                TOUT VOIR
            </button>
         <?php 
    }
}