<?php

namespace Sypres\Components;

use Sypres\Api\Brevo;
use WP_Post;

class Evenement {
    //TODO: delete list in brevo when Evenement is delete ? 

    private const NOUNCE = "sypres_subscribe_event";

    public static function create(WP_Post $evenement, $isOpen = true) {
        ?>
        <div class="evenement text-base">
            <div class="img">
                <img src="<?= get_the_post_thumbnail_url($evenement, 'full');  ?>" alt="">
            </div>
            <div class="text">
                <h3><?= $evenement->post_title ?></h3>
                <div class="content"><?= $evenement->post_content ?></div>
            </div>
            <div class="inscription">
                <div class="block">
                    <span>Date: <?= sypres_get_date_format(get_field( 'date', 'post_'.$evenement->ID )) ?></span>
                    <span>Horaires: <?= get_field( 'horaire', 'post_'.$evenement->ID ) ?></span>
                    <span>Lieu : <?= get_field( 'lieu', 'post_'.$evenement->ID ) ?></span>
                </div>
                <?php if ($isOpen): ?>
                    <a href="<?= $evenement->guid ?>">
                        <?php Vignette::create("Inscrivez-vous vite ! ", 'secondary', 'calendar'); ?>
                    </a>
                <?php endif; ?>
            </div>
        </div>
        <?php 
    }

    public static function register() {
        if( 
            ! isset( $_REQUEST['nonce'] ) or 
            ! wp_verify_nonce( $_REQUEST['nonce'], Evenement::NOUNCE ) 
        ) {
            wp_send_json_error( "Vous n’avez pas l’autorisation d’effectuer cette action.", 403 );
        }

        $data = [
            'email' => $_POST["EMAIL"],
            'listIds' => [get_post_meta($_POST['post_id'], 'list', true), 65],
            "updateEnabled" => true,
            'attributes' => $_POST
        ];

        $brevo = new Brevo();
        $result = $brevo->sendContact($data);
        $response = [ 'success' => $result['success'] ];
        if ($result['success']) {
            $response['url'] = home_url(); 
        }
        wp_send_json_success($response);
    }

    public static function createForm($post) {
        ?>
        <div class="form">
            <form method="post">
                <input type="hidden" name="nonce"value="<?php echo wp_create_nonce( Evenement::NOUNCE ); ?>" >
                <div class="information success hidden">
                    Votre inscription a été correctement effectuée
                </div>
                <div class="information echec hidden">
                    Une erreur s'est produite
                </div>
                <span class="semi-bold">Veuillez renseigner votre adresse email pour vous inscrire<span class="text-secondary">*</span></span>
                <input type="hidden" name="action" value="register_contact_event">
                <input type="hidden" name="post_id" value="<?= $post->ID ?>">
                <input type="email" name="EMAIL" placeholder="Email">
                <input type="text" name="PRENOM" placeholder="Prénom">
                <input type="text" name="NOM" placeholder="Nom">
                <span class="semi-bold">Droit à l'image</span>
                <div class="publicity-right">
                    <input type="checkbox" class="checkbox" value="1" id="OPT_IN" name="OPT_IN">
                    <label for="OPT_IN" class="text-base">J'accepte que des photos de l'événement soient prises pour contribuer à faire connaître les initiatives de Syprès</label>
                </div>
                <div class="valid">
                    <button class="btn primary text-xl">
                        Je m'inscris
                    </button>
                </div>
            </form>
        </div>
        <?php 
    }
}