<?php

namespace Sypres\Components;

use Sypres\Api\Brevo;
use Sypres\Api\PaiementPartSocial;
use Sypres\Utils\Email;

class Devis {

    private const NOUNCE = "sypres_create_devis";
    private const EVENT = "send_devis_resquest";
    public static function create() {
        ?>
        <div class="devis" id="devis">
            <div class="selector">
                <div class="window">
                    <span class=text-4xl>Type d'obsèques envisagées :</span>
                    <div class="types">
                        <div class="type inhumation">
                            <span class="text-xl">Inhumation</span>
                            <img src="<?= get_stylesheet_directory_uri().'/assets/img/inhumation.webp'; ?>" alt="">
                        </div>
                        <div class="type cremation">
                            <span class="text-xl">Crémation</span>
                            <img src="<?= get_stylesheet_directory_uri().'/assets/img/cremation.webp'; ?>" alt="">
                        </div>
                    </div>
                    <div class="img">
                        <img src="<?= get_stylesheet_directory_uri().'/assets/img/newsletter.webp'; ?>" alt="">
                    </div>
                </div>
            </div>

            <?php Devis::getInhumation() ?>
            <?php Devis::getCremation() ?>
        </div>
        <?php 
    }

    public static function devisRequest() {
        if( 
            ! isset( $_REQUEST['nonce'] ) or 
            ! wp_verify_nonce( $_REQUEST['nonce'], Devis::NOUNCE ) 
        ) {
            wp_send_json_error( "Vous n’avez pas l’autorisation d’effectuer cette action.", 403 );
        }

        $data = $_POST;

        Email::send(
            PaiementPartSocial::emails,
            'Demande de devis',
            Email::getTemplateDevis($data)
        );

        $brevo = new Brevo();

        $brevoData = [
			'email' => $_POST["email"],
			'listIds' => [103],
			"updateEnabled" => true,
			'attributes' => array(
				"NOM"=> $_POST["nom"],
				"PRENOM"=> $_POST["prenom"],
				"TELEPHONE" => $_POST["phone"],
				"COMMENTAIRE" => 'Commentaire demande devis: '.$_POST["comment"],
				"OPT_IN" => true
			),
		];

        $result = $brevo->sendContact($brevoData);
        $response = [ 'success' => $result['success'] ];
        if ($result['success']) {
            $response['url'] = home_url(); 
        }
        wp_send_json_success($response);
    }

    public static function getInhumation( $isHidden = true ) {
         ?>
         <div class="obseque inhumation <?= $isHidden ? 'hidden' : '' ?>">
             <?= Devis::getReturn() ?>
            <div class="form">
                <form>
                   <input type="hidden" name="nonce"value="<?php echo wp_create_nonce( Devis::NOUNCE ); ?>" >
                   <input type="hidden" name="action" value="<?= Devis::EVENT ?>">
                   <input type="hidden" name="type" value="inhumation">
                   <?php Devis::getDefaultQuestion(); ?>
                   <div class="item full">
                       <div class="container-movable">
                           <Label class="movable text-base" for="communeInhumation">Commune d'inhumation <span class="text-red">*</span></Label>
                           <input type="text" name="communeInhumation" id="communeInhumation" required>
                       </div>
                   </div>
                   <div class="item">
                       <span>Type de concession <span class="text-red">*</span></span>
                       <div class="row">
                           <input type="radio" name="concession" id="caveau"  value="caveau" required>
                           <Label for="caveau">Caveau</Label>
                       </div>
                       <div class="row">
                           <input type="radio" name="concession" id="terre"  value="terre" required>
                           <Label for="terre">Pleine terre</Label>
                       </div>
                   </div>
                   <?php Devis::getPersonnalInformation(); ?>
                   <?php Devis::getbutton() ?>
               </form>
            </div>
         </div>
         <?php
    }

    public static function getCremation( $isHidden = true ) {

        $crematoriums = get_field('liste_crematoriums', 'option');
        ?>
        <div class="obseque cremation <?= $isHidden ? 'hidden' : '' ?>">
            <?= Devis::getReturn() ?>
            <div class="form">
                <form>
                    <input type="hidden" name="nonce"value="<?php echo wp_create_nonce( Devis::NOUNCE ); ?>" >
                    <input type="hidden" name="type" value="cremation">
                    <input type="hidden" name="action" value="<?= Devis::EVENT ?>">
                    <?php Devis::getDefaultQuestion( 2 ); ?>
                    <div class="aligned">
                        <div class="item">
                            <span>Choix du crématorium <span class="text-red">*</span></span>
                            <?php foreach ($crematoriums as $crematorium): ?>
                                <?php $crematorium = $crematorium['crematorium'] ?>
                                <div class="row">
                                    <input type="radio" name="crematorium" id="<?= acf_slugify($crematorium) ?>"  value="<?= $crematorium ?>" required>
                                    <Label for="<?= acf_slugify($crematorium) ?>"><?= $crematorium ?></Label>
                                </div>
                            <?php endforeach; ?>
                        </div>
                        <div class="item">
                            <span>Destination des cendres <span class="text-red">*</span></span>
                            <div class="row">
                                <input type="radio" name="destination" id="nature"  value="nature" required>
                                <Label for="nature">Dispersion en pleine nature</Label>
                            </div>
                            <div class="row">
                                <input type="radio" name="destination" id="mer"  value="mer" required>
                                <Label for="mer">Dispersion en mer</Label>
                            </div>
                            <div  class="row">
                                <input type="radio" name="destination" id="inhumationCaveau"  value="inhumationCaveau" required>
                                <Label for="inhumationCaveau">Inhumation de l'urne à l'intérieur du caveau</Label>
                            </div>
                             <div  class="row">
                                <input type="radio" name="destination" id="sellementCaveau"  value="sellementCaveau" required>
                                <Label for="sellementCaveau">Sellement de l'urne sur un caveau</Label>
                            </div>
                             <div  class="row">
                                <input type="radio" name="destination" id="columbarium"  value="columbarium" required>
                                <Label for="columbarium">Inhumation de l'urne dans un columbarium ou dans un cavurne</Label>
                            </div>
                        </div>
                    </div>
                    <?php Devis::getPersonnalInformation( 2 ); ?>
                    <?php Devis::getbutton() ?>
                </form>
            </div>
         <?php 
    }

    public static function getReturn() {
         ?>
         <div class="return nav-arrow left"></div>
         <?php 
    }

    public static function getbutton() {
         ?>
        <div class="item">
            <button class="btn primary text-2xl">Envoyer</button>
        </div>
         <?php 
    }


    public static function getDefaultQuestion( $index = 1 ) {
        $index = $index == 1 ? '' : $index
         ?>
         <div class="aligned">
             <div class="item">
                 <span>Situation <span class="text-red">*</span></span>
                 <div class="row">
                     <input type="radio" name="situation" id="decede<?= $index ?>"  value="decede" required>
                     <Label for="decede<?= $index ?>">Décès avéré</Label>
                 </div>
                 <div class="row">
                     <input type="radio" name="situation" id="imminent<?= $index ?>"  value="imminent" required>
                     <Label for="imminent<?= $index ?>">Fin de vie imminente</Label>
                 </div>
                 <div  class="row">
                     <input type="radio" name="situation" id="autre<?= $index ?>"  value="autre" required>
                     <Label for="autre<?= $index ?>">Autre</Label>
                 </div>
             </div>
             <div class="item">
                 <span>Lieu du décès <span class="text-red">*</span></span>
                 <div class="row">
                     <input type="radio" name="lieu" id="hopital<?= $index ?>"  value="hopital" required>
                     <Label for="hopital<?= $index ?>">Hôpital</Label>
                 </div>
                 <div class="row">
                     <input type="radio" name="lieu" id="ehpad<?= $index ?>"  value="ehpad" required>
                     <Label for="ehpad<?= $index ?>">Ehpad ou maison de retraite</Label>
                 </div>
                 <div  class="row">
                     <input type="radio" name="lieu" id="domicile<?= $index ?>"  value="domicile" required>
                     <Label for="domicile<?= $index ?>">Domicile</Label>
                 </div>
             </div>
             <div class="item">
                 <span>Cérémonie <span class="text-red">*</span></span>
                 <div class="row">
                     <input type="radio" name="ceremonie" id="religieuse<?= $index ?>"  value="religieuse" required>
                     <Label for="religieuse<?= $index ?>">Religieuse</Label>
                 </div>
                 <div class="row">
                     <input type="radio" name="ceremonie" id="civile<?= $index ?>"  value="civile" required>
                     <Label for="civile<?= $index ?>">Civile</Label>
                 </div>
             </div>
         </div>
            <div class="item full">
                <div class="container-movable">
                    <Label class="movable text-base" for="communeDeces<?= $index == 1 ? '' : $index ?>">Commune du décès avéré ou probable <span class="text-red">*</span></Label>
                    <input type="text" name="communeDeces" id="communeDeces<?= $index == 1 ? '' : $index ?>" required>
                </div>
            </div>
         <?php 
    }

    public static function getPersonnalInformation( $index = 1 ) {
        $index = $index == 1 ? '' : $index
        ?>
        <div class="item row">
            <div class="container-movable">
                <Label class="movable" for="nom<?= $index  ?>">Nom <span class="text-red">*</span></Label>
                <input type="text" name="nom" id="nom<?= $index ?>" required>
            </div>
            <div class="container-movable">
                <Label class="movable" for="prenom<?= $index ?>">Prénom <span class="text-red">*</span></Label>
                <input type="text" name="prenom" id="prenom<?= $index ?>" required>
            </div>
        </div>
        <div class="item row">
            <div class="container-movable">
                <Label class="movable" for="email<?= $index ?>">Email <span class="text-red">*</span></Label>
                <input type="email" name="email" id="email<?= $index ?>" required>
            </div>
            <div class="container-movable">
                <Label class="movable" for="phone<?= $index ?>">Téléphone</Label>
                <input type="tel" name="phone" id="phone<?= $index ?>">
            </div>
        </div>
        <div class="item">
            <div class="container-movable">
                <Label class="movable text-base" for="comment<?= $index ?>">Question particulière - Autre commentaire</Label>
                <textarea name="comment" id="comment<?= $index ?>"></textarea>
            </div>
        </div>
        <?php  
    }
}