<?php 

namespace Sypres\Components;

use DateTime;
use Sypres\Enum\ThematicName;
use Sypres\Post\Thematic;
use WP_Post;

class Article {

    public static function createContainer(
        string $category
    ) {
        $isAllThematic = $category == ThematicName::NAV->value;
        ?>
            <?php if ( $isAllThematic ): ?>
                <?php Vignette::createContainer(); ?>

            <?php else: ?>
                <?php $thematic = Thematic::get($category);
                    $color = 'grey';
                    if ($thematic) {
                        $color =  $thematic['color'];
                    }
                    $latest_posts = Thematic::getPosts($thematic );
                ?>
                <div class="container-article">
                    <div class="presentation-article <?= $color ?>">
                        <span><?= $category ?></span>
                    </div>
                    <!-- TODO: carousel -->
                    <div class="group">
                        <?php foreach ($latest_posts as $post): ?>
                            <?php Article::create($post, $thematic) ?>
                        <?php endforeach; ?>
                    </div>
                </div>

            <?php endif; ?>
        <?php  
    }

    public static function create(
        WP_Post $post,
        array $thematic
    ) {
        $img = get_the_post_thumbnail_url($post, 'full');
        $text = get_the_excerpt($post);
        $text_length = 200;
        ?>
            <div class="article text-base">
                <a class="img" href="<?= $post->guid ?>">
                    <?php Tag::create($thematic['name'], $thematic['color']) ?>
                    <img src="<?= $img ?>" alt="">
                </a>
                <div class="container">
                    <a class="name bold text-xl" href="<?= $post->guid ?>"><?= $post->post_title; ?></a>
                    <?php Article::getDetails($post); ?>
                    <div class="text"><?= strlen($text) > $text_length ? substr( $text, 0, 200) . "..." : $text ?></div>
                </div>
            </div>
        <?php  
    }

    // ----------- Details ------------------

    public static function getDetails(WP_Post $post, $icon_color = "") {
        $date = "";
        switch ($post->post_type) {
            case 'post':
                $date = $post->post_date;
            case 'evenement':
                $date = get_field( 'date', 'post_'.$post->ID );
        }
        
         ?>

        <span class="details">
            <img src="<?= get_stylesheet_directory_uri().'/assets/img/icon/calendar.svg'; ?>" alt="" class="<?= $icon_color ?>">
            &nbsp;
            <?= sypres_get_date_format($date); ?>
            &nbsp;
            .
            &nbsp;
            <img src="<?= get_stylesheet_directory_uri().'/assets/img/icon/time.svg'; ?>" class="<?= $icon_color ?>" alt="">
            &nbsp;
            <?php 
            $reading_time = get_post_meta($post->ID, 'reading_time')[0];
            echo $reading_time.' min'. ($reading_time == 1 ? '' : 's') ?>
        </span>
         <?php 
    }
}