<?php 

namespace Sypres\Api;

use Sypres\Api\Brevo;

class PaiementPartSocial {

	const emails = ['celine@taketik.fr', 'accueil@sypres.fr', 'olivier.jaupitre@sypres.fr'];
	//const stripe_public_key = 'pk_live_51PApFF07M4Dx3Er77bFZESe0AIE7cBpRftWpt3EE4LgYAVmMkQEZupUnMCvOhA7Ju7zjQ7PryxvCWutpVFtr1b3u00jKrIzTHH';
	const stripe_public_key = 'pk_test_51PApFF07M4Dx3Er7C8Hs6TP4lvxew4PG9ugHvq9oGhMeDOJ0096fJMrMN6EKx0R7SpLrry8OLLPctoTFvyacRd9g00hnL1hTeI';
	//const stripe_secret_key = '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';
	const stripe_secret_key = 'sk_test_51PApFF07M4Dx3Er70hEzsH0dryKHGP469XhDBXvjG34Bcu5mY7HQoxmRSDOL0ls0LBliv8aZSmKmXI29f8VEAWAC00KMaSEmKB';

	public static function getStripeApiKey() {
		wp_send_json_success(
			PaiementPartSocial::stripe_public_key
		);
	}

	public static function clientSecret() {
		$url = "https://api.stripe.com/v1/payment_intents";
		$data = 'amount=' . $_POST[ 'amount' ] * 50 * 100 . '&'.'currency=' . $_POST[ 'currency' ];

		$headers = array(
			'Content-Type: application/x-www-form-urlencoded',
			'Authorization: Bearer '. PaiementPartSocial::stripe_secret_key,
		);

		$ch = curl_init($url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		
		$response = curl_exec($ch);
		$res_err_number = !curl_errno($ch);
		$res_err_message = curl_error($ch);
		
		$response = json_decode($response);
		curl_close($ch);

		if (property_exists($response, 'error')) {
			wp_send_json_success([ "success" => false, "error" => $response->message, "client_secret" => null]);
			return;
		}

		if(!session_id()) {
			session_start();
		}

		$_SESSION["client_secret"] = $response->client_secret;
		$_SESSION["share"] = $_POST[ 'amount' ];
		wp_send_json_success([ "success" => true, "error" => "", "client_secret" => $response->client_secret]);
	}

	public static function validMember() {
		//TODO: wp_mail("nicolas@taketik.fr", "sypres", $_POST["client_secret"]. "\n" . $_SESSION["client_secret"]);
		$categories = explode(',', $_POST["category"]);
		if ($_POST["payment"] === "card") {
			if ($_POST["client_secret"] != $_SESSION["client_secret"]) {
				$message = "Bonjour, une erreur, s'est produite lors du paiement par carte, voici les informations de la personne concernée :";
				PaiementPartSocial::sendEmailToAdmin($message, "Une erreur est arrivée lors du paiement.");
				wp_send_json_success(['success' => false, 'url' => site_url()]);
			}
			$col_and_list = PaiementPartSocial::dataImmediatePayment($categories, $_SESSION["share"]);
		}
		else {
			$col_and_list = PaiementPartSocial::dataDeferPayment($categories, $_POST["share"]);
		}

		$listIds = $col_and_list[0];
		$waiting_payment = $col_and_list[1];
		$share = $col_and_list[2];

		$phone = $_POST["phone"];
		if (substr($phone, 0, 1) === '0'){
			$phone = '0033'. substr($phone, 1);
		}

		$brevo = new Brevo();
		$result = $brevo->getContact($_POST["email"]);

		if ($result["success"] ){
			$blocking_list_id = [59, 60, 61, 62, 63, 66];
			$users_ids = $result["get"]->listIds ?? [];
			$is_user_subscribe = false;
			for ($i = 0; $i < count(value: $users_ids); $i++) {
				if(in_array($users_ids[$i], $blocking_list_id)){
					$is_user_member = true;
				}
			}
			if ( $is_user_member ) {
				$share += $result["get"]->attributes->NOMBRE_DE_PARTS;
				$_POST["payment"] === "card" ? $listIds = [] : $listIds = [67];
				if ( $waiting_payment != "") {
					$strArray = explode(' ', $waiting_payment);
					$waiting_payment = $strArray[0] . ' ' . $strArray[1];
				}
			}	
		}

		if ( $waiting_payment == "" ) {
			$waiting_payment = $result["get"]->attributes->ATTENTE_VALIDATION;
		}

		$data = [
			'email' => $_POST["email"],
			'listIds' => $listIds,
			"updateEnabled" => true,
			'attributes' => array(
				"CIVILITE" => $_POST["civility"],
				"DATE_NAISSANCE" => $_POST["birthday"],
				"NOM"=> $_POST["lastName"],
				"PRENOM"=> $_POST["firstName"],
				"ADRESSE"=> $_POST["address"],
				"CP"=> $_POST["postcode"],
				"VILLE"=> $_POST["city"],
				"TELEPHONE" => $phone,
				"NOMBRE_DE_PARTS" => $share,
				"COMMENTAIRE" => $_POST["comment"],
				"ATTENTE_VALIDATION" => $waiting_payment,
				"OPT_IN" => true
			),
		];

		if ($_POST["isMember"] == "Societaire" || $_POST["payment"] != "card") {
			if ($_POST["isMember"] == "Societaire") {
				$message = "Bonjour, un.e sociétaire a repris des parts sociales, voici ses informations :";
				$subject = "Un.e sociétaire a repris des parts sociales";
			}
			else {
				$message = "Bonjour, un.e sociétaire veut acheter des parts sociales, voici ses informations :";
				$subject = "Un.e sociétaire veut acheter des parts sociales";
			}
			PaiementPartSocial::sendEmailToAdmin($message, $subject, $listIds, $_POST["payment"] != "card");
		}

		//wp_mail("nicolas@taketik.fr", "sypres", json_encode($result). "\n\n" . json_encode($data));

		$brevo->sendContact($data);

		$url = site_url() . "/merci-pour-votre-demande-de-souscription";

		session_destroy();

		wp_send_json_success(['success' => true, 'url' => $url]);
	}

	public static function sendEmailToAdmin($message, $subject, $listIds = null, $deferMessage = false) {
		$mails = PaiementPartSocial::emails;
		$message = $message ."\n".
			"NOM: " . $_POST["civility"]. ' ' . $_POST["lastName"] . ' ' . $_POST["firstName"] . "\n" .
			"DATE DE NAISSANCE: " . $_POST["birthday"]. "\n" .
			"ADRESSE: " . $_POST["address"]. "\n" .
			"CP: " . $_POST["postcode"]. "\n" .
			"VILLE: " . $_POST["city"]. "\n" .
			"TELEPHONE: " . $_POST["phone"] . "\n" .
			"NOMBRE DE PARTS: +" . $_POST["share"]. "\n" .
			"EMAIL: +" . $_POST["email"]. "\n" .
			"COMMENTAIRE: " . $_POST["comment"]. "\n";
		if ($listIds != null) {
			$message .= "LIST: " . json_encode($listIds). "\n" ;
		}

		if ($deferMessage){
			$message .= "Attention, la personne a choisi de payer par virement ou chèque. Ne pas hésiter à le relancer si Syprès n'a rien reçu d'ici quelques jours.\n" .
			"Lorsque les fonds seront reçus, il faudra : \n
				- modifier dans Brévo manuellement le nombre de parts sociales que détient la personne.
				- Ajouter la personne à la liste correspondante
				- Supprimer la mention \"attente validation\"";
		}

		for ($i = 0; $i < count($mails); $i++) { 
			wp_mail($mails[$i] , $subject, $message);
		}
	}

	public static function dataImmediatePayment($categories, $share = 0) {
		$listIds = [];
			foreach( $categories as $type ){
				switch($type) {
					case "Salari":
						$listIds[] = 62;
						break;
					case "Famille":
						$listIds[] = 59;
						break;
					case "Soutien":
						$listIds[] = 63;
						break;
					case "Collectivit territoriale":
						$listIds[] = 66;
						break;
					case "Partenaire pers morale":
						$listIds[] = 60;
						break;
					case "Prestataire contrat fourniture":
						$listIds[] = 61;
						break;
				}
			}
		return [$listIds, "", $share];
	}

	public static function dataDeferPayment( $categories, $share ) {
		$listIds = [67];
		$waiting_payment = "Parts: ". $share. " - ";
		foreach( $categories as $type ){
			switch($type) {
				case "Salari":
					$waiting_payment .= "SALARIE:62";
					break;
				case "Famille":
					$waiting_payment .= "FAMILLE:59";
					break;
				case "Soutien":
					$waiting_payment .= "SOUTIEN:63";
					break;
				case "Collectivit territoriale":
					$waiting_payment .= "COLLERTIVITE:66";
					break;
				case "Partenaire pers morale":
					$waiting_payment .= "PART_PERS_MORALE:60";
					break;
				case "Prestataire contrat fourniture":
					$waiting_payment .= "CONTRAT_FOURNITURE:61";
					break;
			}
			$waiting_payment .= " - ";
		}
		$waiting_payment = substr($waiting_payment, 0, -3);
		return [$listIds, $waiting_payment, 0];
	}
}