<?php 

namespace Sypres\Api;

use WP_Post;


/**
 * See https://developers.brevo.com/reference/getcontacts-1 for doc
 */
class Brevo
{
    private const key = "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";
    private const url = "https://api.brevo.com/v3";

    public function getContact( string $email) {
        $url = self::url . '/contacts/' . $email;
        $result = $this->get($url);
        $result['success'] = isset($result["get"]->code) && $result["get"]->code === "document_not_found" ? 
            false : 
            true;

        return $result;
    }

    public function sendContact($data) {
        $url = self::url . '/contacts';
        $result = $this->post($url, $data);
        $result['success'] = isset($result["get_code"]) && ($result["get_code"] == "201" || $result["get_code"] == "204") ? 
            true : 
            false;
        return $result;
    }

    public function createList(WP_Post $event) {
        error_log(json_encode($event));

        $url = self::url. '/contacts/lists';
        $data = [
            'name' => get_field( 'date', 'post_'.$event->ID ) .'-'. $event->post_title
        ];
        $result = $this->post($url, $data);
        error_log(json_encode($result));
        add_post_meta( $event->ID,  'list', $result['get']['id'], true );
    }

    public function get( $url ) {
          $headers = array(
            'Content-Type: application/json',
            'Api-Key: '.self::key,
        );
    
        $ch = curl_init($url);
    
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    
        $result = [];
        $result["get"]  = json_decode(curl_exec($ch));
        $result["get_code"] = curl_errno($ch);
        $result["get_message"]  = curl_error($ch);
    
        curl_close($ch);
    
        return $result;
    }

    public function post($url, $data) {
         $headers = array(
            'Content-Type: application/json',
            'Api-Key: ' . self::key,
        );
    
        $ch = curl_init($url);
    
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $result = [];
        $result["get"]  = json_decode(curl_exec($ch));
        $result["get_code"] = curl_errno($ch);
        $result["get_message"]  = curl_error($ch);
    
        curl_close($ch);
    
        return $result;
    }

}