<?php

use Sypres\Components\Breadcrumb;
use Sypres\Components\Faq;

/*
 * Page d'isncription Evenement
 */

$post = get_post();
?>

<?php get_header();?>

<div class="main page-article">
    <div class="header-wrapper">
        <div class="header">
            <div class="overlay"></div>
            <div class="featured-image"> 
                <img src="<?= get_the_post_thumbnail_url($post, 'full');  ?>" alt="">
            </div>
        </div>
        <div class="intro-wrapper">
            <div class="intro appear appear-long bg-primary flex v-center p-2 appear-visible" style="opacity: 1;">
                <h2 class="text-primary"><?= $post->post_title ?></h2>
            </div>
        </div>
    </div>
    <div class="content">
        <div class="column left">
            <?php Breadcrumb::create() ?>
            <?= $post->post_content ?>
        </div>
        <div class="column right">
            <?php Faq::createGeneric() ?>
        </div>
    </div>
    <?php 
    if (comments_open() || get_comments_number()) {
        comments_template( '/comments.php', true );
    } ?>
</div>

<?php get_footer(); ?>