<?php



define('AVIS_DEV_MODE', false);



define('AVIS_EMAIL_DEV', 'stephane.dmln@gmail.com');



define('AVIS_EMAIL_FROM', 'accueil@sypres.fr');



define('AVIS_EMAIL_COMMENT_NOTIF', 'accueil@sypres.fr');









/**

	CUSTOM POST TYPE

 ==========================================================

*/



function cpt_avis_add() {



	/* Property */

	$labels = array(

		'name'                => _x('Avis', 'Post Type General Name', 'fasterthanlight'),

		'singular_name'       => _x('Avis', 'Post Type Singular Name', 'fasterthanlight'),

		'menu_name'           => __('Avis', 'fasterthanlight'),

		'name_admin_bar'      => __('Avis', 'fasterthanlight'),

		'parent_item_colon'   => __('Parent Item:', 'fasterthanlight'),

		'all_items'           => __('Tous les avis', 'fasterthanlight'),

		'add_new_item'        => __('Ajouter un nouvel avis', 'fasterthanlight'),

		'add_new'             => __('Ajouter un avis', 'fasterthanlight'),

		'new_item'            => __('New Item', 'fasterthanlight' ),

		'edit_item'           => __('Modifier', 'fasterthanlight'),

		'update_item'         => __('Mettre à jour', 'fasterthanlight'),

		'view_item'           => __('Voir un avis', 'fasterthanlight'),

		'search_items'        => __('Rechercher un avis', 'fasterthanlight'),

		'not_found'           => __('Aucun résultat', 'fasterthanlight'),

		'not_found_in_trash'  => __('Aucun résultat dans la corbeille', 'fasterthanlight'),

	);

	$rewrite = array(

		'slug'                => _x('avis', 'avis', 'fasterthanlight'),

		'with_front'          => true,

		'pages'               => true,

		'feeds'               => false,

	);

	$args = array(

		'label'               => __('avis', 'fasterthanlight'),

		'description'         => __('Avis de décès', 'fasterthanlight'),

		'labels'              => $labels,

		'supports'            => array('title', 'editor', 'thumbnail', 'comments'),

		'taxonomies'          => array('avis_taxo'),

		'hierarchical'        => false,

		'public'              => true,

		'show_ui'             => true,

		'show_in_menu'        => true,

		'menu_position'       => 5,

		'menu_icon'           => 'dashicons-text-page',

		'show_in_admin_bar'   => true,

		'show_in_nav_menus'   => true,

		'can_export'          => true,

		'has_archive'         => 'tous-les-avis',

		'exclude_from_search' => false,

		'publicly_queryable'  => true,

		'query_var'           => 'avis',

		'rewrite'             => $rewrite,

		'capability_type'     => 'page',

	);

	register_post_type('avis', $args);	

}



add_action('init', 'cpt_avis_add', 10);





// Autoriser les commentaires par défaut sur le CPT Avis

add_filter( 'wp_insert_post_data', 'cpt_avis_comments_on' );

function cpt_avis_comments_on( $data ) {



    if( $data['post_type'] == 'avis' ) {

        $data['comment_status'] = "open";

    }



    return $data;

}













// This is where you'd do the validations:

add_filter( 'preprocess_comment', 'verify_comment_meta_data' );

function verify_comment_meta_data( $commentdata ) {	

    $post_type = get_post_type( $commentdata['comment_post_ID'] ); 

	

	if($post_type != 'avis')

		return $commentdata;

		

    // if ( $_POST['avis-honey'] != '' ){

		// wp_die( __( 'Ce message a été reconnu comme un spam. Merci de contacter directement la Coopérative pour assurer la publication de votre message.' ) );

	// }

		

    if ( ! isset( $_POST['avis-destinataire'] ) or empty( $_POST['avis-destinataire'] ) )

        wp_die( __( 'Erreur : champ avis-destinataire vide.' ) );

	

	

	$_SESSION['coopfun_comment'] = true;

	

	return $commentdata;



	// disp($_SESSION); 

	// disp($_POST); 

	// exit();    

}



// Save the comment meta:

add_action( 'comment_post', 'save_comment_meta_data' );

function save_comment_meta_data( $comment_id ) {

	

	if ((int)$_POST[ 'avis-is-private' ] === 1){

		$is_private = 1;

	}else{

		$is_private = 2;

	}

	

    add_comment_meta( $comment_id, 'destinataire', $_POST[ 'avis-destinataire' ] );

    add_comment_meta( $comment_id, 'is-private', $is_private );

    add_comment_meta( $comment_id, 'image', $_POST[ 'avis-image' ] );

}







// Retrieve and display comment meta:

// add_filter( 'get_comment_author_link', 'attach_city_to_author' );

function attach_city_to_author( $author ) {

    $city = get_comment_meta( get_comment_ID(), 'city', true );

    if ( $city )

        $author .= " ($city)";

    return $author;

}











/**

	ENVOI DU MAIL SUR VALIDATION DU COMMENTAIRE

 ==========================================================

*/



add_action('transition_comment_status', 'approve_comment_callback', 10, 3);



function approve_comment_callback($new_status, $old_status, $comment) {

	// status : spam/unapproved/approved

	

	

	$commentID = $comment->comment_ID;

	$avisID = $comment->comment_post_ID;

	

	$optout 			= (int)get_post_meta($avisID, 'optout', true);

	$int_is_private 	= (int)get_comment_meta( $comment->comment_ID, 'is-private', true );

	$destinataire 		= get_comment_meta( $comment->comment_ID, 'destinataire', true );

	$image 				= get_comment_meta( $comment->comment_ID, 'image', true );

	$is_comment_private = ($int_is_private === 1) ? true : false;

	$optout_url 		= get_site_url() . '?avis_optout=1&avis_id=' . $comment->comment_post_ID;

	$destinataire_email = get_post_meta($avisID, '_crb_contact', true);

	

			

	

	// ==================================================

	// CONDITIONS D'ENVOI DU MAIL

	// ==================================================

	

	// if(!$is_comment_private){

		// echo 'MAIL NOT SENT. REASON: Commentaire public. | ' . $is_comment_private;

		// return;

	// }

	

	if($old_status == $new_status){

		// echo 'MAIL NOT SENT. REASON:  old_status == new_status | ' . $old_status . '==' . $new_status;

		return;

	}

	

	if($new_status != 'approved'){

		// echo 'MAIL NOT SENT. REASON : le nouveau statut du commentaire n\'est pas "approuvé" | ' . $new_status;

		return;

	}

	

	if(isset($optout) and $optout == 1){

		// echo 'MAIL NOT SENT BECAUSE optout == 1 | ' . $optout;

		return;

	}

	

	

	// ==================================================

	// ENVOI DU MAIL

	// ==================================================

		

	

	// Destinataire / Objet

	// ---------------------------------	

	$fromTexte = $comment->comment_author;

	

	// Mettre le vrai ndd pour augmenter les chances de réception

	$fromEmail = AVIS_EMAIL_FROM;	

	$subject = 'Un message de ' . $comment->comment_author;

	

	

	// Headers

	// ---------------------------------

	$headers = "From: \"". $fromTexte ."\"<". $fromEmail .">\n";

	$headers .= "Reply-To: ". $comment->comment_author_email ."\n";

	$headers .= "Content-Type: text/html; charset=\"utf-8\"";

	

	// MQ (ne fonctionne pas)

	$style = '

	<style>

		@media only screen and (min-width: 320px) and (max-width: 767px) {

			.coopfunrennes-image {

				float: none !important;	

				width: 100%;					

			}

		}

	</style>

	';						

	

	// Image

	if(substr($image, -10) != 'spacer.png'){

		$html_image = '			

			<p style="margin-top: 30px; font-family: Georgia, sans-serif; font-size: 12px; color: #555555; text-align: center;" class="coopfunrennes-image">

				<img width="250" height="250" style="border-radius: 50%;" src="'. $image .'" alt="Cette illustration vous est proposée par un artiste partenaire de la Coopérative. Cliquez sur Afficher les images, ou Afficher le contenu bloqué pour faire apparaître cette image."/>	

			</p>	

		';				

	}else{				

		$html_image = '';

	}

		

		

	// Message

	// ---------------------------------

	$message = '

		

		<div style="">					

			<p style="font-family: Georgia, sans-serif; font-size: 22px; color: #222222; line-height: 1.6;">

				'. nl2br($comment->comment_content) .'	

			</p>

			<p style="margin-top: 30px; font-family: Georgia, sans-serif; font-size: 18px; color: #222222; font-style: italic;">

				'. $comment->comment_author .'	

			</p>

			<p style="margin-top: 5px; font-family: Georgia, sans-serif; font-size: 14px; color: #222222; font-style: italic;">

				à l\'attention de : '. $destinataire .'	

			</p>

			

							

			'. $html_image .'

								

			<br/><br/><br/>

							

			<p style="margin-top: 10px; font-size: 10px; color: #222222; text-align: center;">

				Si vous ne souhaitez plus recevoir d\'emails de la Coopérative Funéraire, <a href="'. $optout_url .'" target="_blank">cliquez ici</a>.

			</p>										

		</div>

	';

	

		

	

	// Envoi du mail

	// ---------------------------------

	

	if(wp_mail( $destinataire_email, $subject, $message, $headers )){

		// echo 'Mail envoyé';

	}else{

		// echo "Erreur avec le mail";

		// print_r($message);

	}		

    

}







/**

	ENVOI DE LA NOTIFICATION D'UN NOUVEAU COMMENTAIRE

 ==========================================================

*/

function se_comment_moderation_recipients( $emails, $comment_id ) {

    $comment = get_comment( $comment_id );

    $post = get_post( $comment->comment_post_ID );

	

	if(!AVIS_DEV_MODE){

		$emails = array( AVIS_EMAIL_COMMENT_NOTIF );

	}else{

		$emails = array( AVIS_EMAIL_DEV );

	}

	

    return $emails;

}

add_filter( 'comment_moderation_recipients', 'se_comment_moderation_recipients', 11, 2 );

add_filter( 'comment_notification_recipients', 'se_comment_moderation_recipients', 11, 2 );









/**

	RECUPERER UN OPTOUT

 ==========================================================

*/

add_action('init', 'cpt_avis_get_optout');

function cpt_avis_get_optout(){	

	if(isset($_GET['avis_id']) and isset($_GET['avis_optout'])){

		$post_id = (int)$_GET['avis_id'];

		$avis_optout = (int)$_GET['avis_optout'];

				

		if(get_post_type($post_id) == 'avis' and $avis_optout == 1){		

			add_post_meta($post_id, 'optout', 1, true);

		}

	}

}









/**

	METABOXES AVIS ET COMMENTAIRES

 ==========================================================

*/



function avis_message_data_metabox($post,$metabox){

	

	

	if($post->post_type != 'avis')

		return;

	

	$int_is_private = (int)get_comment_meta( $post->comment_ID, 'is-private', true );

	$destinataire = get_comment_meta( $post->comment_ID, 'destinataire', true );

	$is_private = ($int_is_private === 1) ? true : false;

		

	$style = '

		<style>

			.form-table.editcomment tr:nth-child(3) {

				display: none;

			}

			

			.adminbox-avis-datalist {

				list-style: disc;

				margin: 20px;

			}

		</style>';

		

		

	

			

	$layout = '

		<ul class="adminbox-avis-datalist">

			<li>Destinataire : <strong>'. $destinataire .'</strong></li>

			<li>Ce message est <strong>'. ($is_private === true ? 'privé' : 'public') .'</strong>. Si vous approuvez ce message, il sera '. ($is_private ? 'envoyé par mail au destinataire' : 'affiché sur le site') .'.</li>

			<li>Image choisie : </li>

		</ul>

	

		<p></p>	

	';

	

	

	echo $layout;

	echo $style;

}



function avis_optout_metabox($post,$metabox){

	

		// return;

	if($post->post_type != 'avis')

		return;

	

	$optout = (int)get_post_meta($post->ID, 'optout', true);



	$layout = '<p>';

	$layout .= 'RGPD : l\'envoi de mails ';

	if(isset($optout) and $optout == 1){

		$layout .= '<strong style="color: red">n\'est plus autorisé</strong>';

	}else{

		$layout .= '<strong style="color: green">est autorisé</strong>';

	}

	$layout .= ' pour cette personne';



	echo $layout;

}



function wpdocs_register_meta_boxes() {

	global $post, $pagenow ;

		

	if($pagenow == 'comment.php'){

		add_meta_box( 'cpt_avis_comment_metabox_01', __( 'Informations complémentaires', 'textdomain' ), 'avis_message_data_metabox', 'comment', 'normal' );

	}		

		

	if(!empty($post) and $post->post_type == 'avis'){

   	 	add_meta_box( 'cpt_avis_metabox_01', __( 'Informations complémentaires', 'textdomain' ), 'avis_optout_metabox' );

	}

}

add_action( 'add_meta_boxes', 'wpdocs_register_meta_boxes' );

 





