document.addEventListener("DOMContentLoaded",function(){

	CoopFunAvis.init();

});


const CoopFunAvis = {
	
	breakpoint: {

		tablet: 1023,

		mobile: 719
	},
	
	init: function(){
		this.body 					= document.querySelector("body");
		const picture 				= document.querySelector('.form-avis--inpiration-picture img');
		const removePic 			= document.querySelector('.form-avis--inpiration-picture-close');
		const sidebarWrapper		= document.querySelector('.sidebar-inspiration--wrapper');
		const sidebarSeemore		= document.querySelector('.sidebar-inspiration--seemore');
		const formAvis 	 			= document.querySelector('#form-avis');
		const btnSubmit 			= document.querySelector('#avis-submit');
		const inputImage 			= document.querySelector('#avis-image');
		const inspirationWrapper 	= document.querySelector('.form-avis--inpiration-wrapper');
		const sidebarInspiration 	= document.querySelector('.sidebar-inspiration');
		
		if(this.body.classList.contains("single-avis")){
			const artworks 				= document.getElementsByClassName('artwork');
			
			const emptySrc 	= picture.src;
			
			for(const artwork of artworks){				
				const artworkSrc = artwork.querySelector('.artwork--picture').src;
				
				artwork.addEventListener('click', function(){
					picture.src = artworkSrc;
					removePic.style.display = 'block';
				});				
			}
			
			removePic.addEventListener('click', function(){
				picture.src = emptySrc;
				removePic.style.display = 'none';
			});

			sidebarSeemore.addEventListener('click', function(){
				sidebarWrapper.scrollTop += 250;
			});	

			formAvis.addEventListener('submit', function(e){
				inputImage.value = picture.src;
				// e.preventDefault();
				// return false;
			});			
		}
		
		if(window.innerWidth <= CoopFunAvis.breakpoint.mobile){

			if(inspirationWrapper != undefined && sidebarInspiration != undefined){
				inspirationWrapper.appendChild(sidebarInspiration);
			}

		}
	}
}