<?php

use Sypres\Navigation\Navbar;

/**
 * 
 * Affichage du head et de tout ce qui précède
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage MA
 * @since MA 1.0
 */


?>
<!doctype html>
<html <?php language_attributes(); ?> style="margin-top: 0 !important;">
  <head>
    <meta charset="<?php bloginfo('charset'); ?>" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <?php wp_head(); ?>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">
  </head>

  <body <?php body_class(); ?>>
    <header class="text-xl">
      <?php Navbar::createSecondMenu() ?>
      <?php Navbar::create(); ?>
    </header>
