<?php
function sypres_enqueue_file() {
  // Register theme stylesheet.
  $theme_version = wp_get_theme()->get( 'Version' );

  $version_string = is_string( $theme_version ) ? $theme_version : false;
  wp_register_style(
    'sypres-style',
    get_template_directory_uri() . '/style.css',
    array(),
    $version_string
  );

	wp_enqueue_script( 'stripe', 'https://js.stripe.com/v3/' );

  // Enqueue theme stylesheet.
  wp_enqueue_style( 'sypres-style' );
  wp_enqueue_script('sypres-script', get_template_directory_uri() . '/assets/js/script.js', [], wp_get_theme()->Version);
	wp_localize_script('sypres-script', 'ajaxObject', array('url' => admin_url('admin-ajax.php')));
}

add_action( 'wp_enqueue_scripts', 'sypres_enqueue_file' );


function sypres_load_custom_wp_admin_style(){
    $theme_version = wp_get_theme()->get( 'Version' );

    wp_register_style(
      'admin-sypres-style',
      get_template_directory_uri() . '/admin.css',
      array(),
      $theme_version
    );
    wp_enqueue_style( 'admin-sypres-style' );

}
add_action('admin_enqueue_scripts', 'sypres_load_custom_wp_admin_style');