<?php 

use Sypres\Post\Evenement;
use Sypres\Post\Post;

add_action('save_post', 'sypres_save_article', 10, 3);

function sypres_save_article($post_id, $post, $update) {

    // Prevent infinite loops & autosaves
    if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return;
    if ( wp_is_post_revision( $post_id ) ) return;

    if ( $post->post_type == 'evenement' ) {
        Evenement::new($post_id, $post );
    } 

    if ( $post->post_type == 'post' || $post->post_type == 'evenement' ) {
        Post::save($post_id, $post);
    };
}
function sypres_get_date_format( $date ) {
    $date = new DateTime($date ); 
    $formatted = $date->format('d'). ' '.
        sypres_get_month($date->format('m')).' '.
        $date->format('Y');
    return $formatted;
}

function sypres_get_month($month) {
    $monthNames = array(
        "01" => 'jan',
        "02" => 'fév',
        "03" => 'mars',
        "04" => 'avril',
        "05" => 'mai',
        "06" => 'juin',
        "07" => 'juil',
        "08" => 'août',
        "09" => 'sept',
        "10" => 'oct',
        "11" => 'nov',
        "12" => 'déc'
    );
	return $monthNames[$month];
}