<?php 
use Sypres\Enum\ThematicName;

add_filter('acf/load_field/name=category_selector', 'sypres_load_category_choices');
add_filter('acf/load_field/name=thematic_selector', 'sypres_load_thematic_choices');

function sypres_load_category_choices( $field, $hasAll = true ) {
    // reset choices
    $field['choices'] = [];

    $categories = get_terms([
        'taxonomy'   => 'category',
        'hide_empty' => false,
    ]);

    foreach( $categories as $category ) {
        if ($category->slug == "non-classe") { continue; }
        $field['choices'][$category->name] = $category->name;
    }

    if ($hasAll) {
        $field['choices'][ThematicName::NAV->value] = "Toutes les Thématiques";
    }
    
    $field['choices'][ThematicName::EVENT->value] = "Evénement";

    return $field;
}

function sypres_load_thematic_choices( $field ) {
    return sypres_load_category_choices( $field, false );
}

add_filter('acf/load_field/name=color_selector', 'sypres_load_color_choices');

function sypres_load_color_choices( $field ) {
    $colors = [
        "primary" => "Vert",
        "secondary" => "Rose",
        "ternary" => "Orange",
        "grey" => "Gris",
    ];

    $field['choices'] = $colors;

    return $field;
}