<?php
/**
 * The template for displaying Comments.
 *
 * The area of the page that contains comments and the comment form.
 *
 * @package WordPress
 * @subpackage Twenty_Thirteen
 * @since Twenty Thirteen 1.0
 */
 
/*
 * If the current post is protected by a password and the visitor has not yet
 * entered the password we will return early without loading the comments.
 */
if ( post_password_required() )
    return;



?>
 
<div class="tpl-comments-area">	
	
<form action="<?php echo site_url(); ?>/wp-comments-post.php" method="post" id="form-avis" class="comment-form form-avis">
<!--
	<p class="avis-comment-notes">
		<span id="email-notes">Votre adresse e-mail ne sera pas publiée.</span> 
		Les champs obligatoires sont indiqués avec <span class="required">*</span>
	</p>
-->
	<p class="form-avis--field">
		<label for="avis-destinataire">Nom de la personne à qui vous désirez envoyer le message :</label>
		<input id="avis-destinataire" name="avis-destinataire" type="text"required="required" placeholder="ex : à l'attention de la famille de M. Gagnon"/>
	</p>

	<p class="form-avis--field">
		<label for="author">Votre Prénom et Nom : </label> 
		<input id="avis-author" name="author" type="text" value="" size="30" maxlength="245" required="required" placeholder="ex : Isabelle Dupont"/>
	</p>

	<p class="form-avis--field">
		<label for="email">Votre courriel :</label> 
		<input id="avis-email" name="email" type="text" value="" size="30" maxlength="100" aria-describedby="email-notes" required="required"placeholder="ex : isabelledupont@exemple.com"/>
	</p>

	<p class="form-avis--field">
		<label for="avis-comment">Votre message :</label> 
		<textarea id="avis-comment" name="comment" cols="45" rows="8" maxlength="65525" required="required"></textarea>
	</p>
	
	<div class="form-avis--inpiration">
		<h3 class="form-avis--inpiration-title">Besoin d'inspiration ?</h3>
		<p class="form-avis--inpiration-text">
			Parfois, on ne sais pas trouver les mots... Une image, ça peut aider pour commencer.<br/>
			Sélectionnez dans la colonne de droite l’œuvre qui vous inspire et qui complètera votre message.
		</p>
		
		<div class="form-avis--inpiration-wrapper">
			<figure class="form-avis--inpiration-picture">
				<span class="form-avis--inpiration-picture-close">&times;</span>
				<img class="" src="<?php echo get_stylesheet_directory_uri(); ?>/assets/img/avis/spacer.png" alt=""/>
			</figure>
		</div>
		
		<input id="avis-image" name="avis-image" type="hidden" value="">
	</div>

	<p class="form-avis--field is--field-private">
		<input id="avis-is-private" name="avis-is-private" type="checkbox" value="1">
		<label class="" for="avis-is-private">
			<span class="form-avis--checkbox-fake"></span>
			Je souhaite que mon message soit envoyé par mail et ne soit pas publié sur ce site
		</label>
	</p>
	
	<p class="form-avis--rgpd">En cliquant sur le bouton ci-dessous, je reconnais avoir lu et compris <a target="_blank" href="<?php echo get_permalink(3); ?>">la politique d'utilisation des données utilisateur</a>. Votre adresse e-mail ne sera pas publiée sur le site ni transmise à des tiers.</p>

	<p class="form-avis--submit">
		<input type="text" class="form-avis--honey" name="avis-honey" id="avis-honey" value=""/>
		<input name="submit" type="submit" id="avis-submit" class="" value="Envoyer mon message"> 
		<input type="hidden" name="comment_post_ID" value="<?php the_ID(); ?>" id="comment_post_ID">
		<input type="hidden" name="comment_parent" id="comment_parent" value="0">
	</p>
</form>
	
	
	
	
	
	<script>
	
	// document.getElementById('avis-comment').innerHTML = "Je vous souhaite tout le réconfort, le soutien, le courage et la bienveillance que vous méritez dans ce moment difficile. Je suis de tout cœur avec vous dans cette épreuve et vous témoigne toute ma sympathie. "+ Date.now() +" Vous pouvez compter sur moi à tout moment !";
	// document.getElementById('avis-author').value = 'Isabelle Martin';
	// document.getElementById('avis-email').value = 'isabelle.martin'+ Date.now() +'@gmail.com';
	// document.getElementById('avis-destinataire').value = 'famille de M. Gageon';
	
	</script>
	
	
 
</div><!-- #comments -->