let formValid = false;
let validData = {};
const PU_SHARE = 50;

//55

document.addEventListener('DOMContentLoaded', () => {
  if ( !document.querySelector('.formulaire-souscription') ){
    return;
  }

  setTimeout(() => {
	  // Calcul Price and show result
    const puElement = document.querySelector('#pu');
    const nbPartsElement = document.querySelector('.nb-parts'); 
    puElement.innerHTML = PU_SHARE;

    nbPartsElement.addEventListener('keyup', computeSharePrice);
    nbPartsElement.addEventListener('change', computeSharePrice);

    document.querySelector("#nf-label-field-47 a").setAttribute("target", "_blank");

    document.getElementById("nf-label-field-53").addEventListener("click", () => {
      let button = document.querySelector(".ninja-forms-field.nf-element.datepicker.pikaday__display.pikaday__display--pikaday.form-control");
      button.click();
    })

    // Put label on top of input
    let ids = [33, 34, 36, 53, 37, 38, 39, 40, 46];
    for ( let i = 0; i < ids.length; i++) {
      const index = ids[i];
      document.getElementById("nf-field-" + index).addEventListener("input", () => {
        let label = document.querySelector("#nf-field-" + index + "-wrap .nf-field-label");
        switch (index) {
          // case comment
          case 46:
            label.style.top = "-15%";
            break;
          // case phone
          case 40:
            label.style.top = "-30px";
            break;
          default:
            label.style.top = "-30px";
            break;
        }
      });
    }
	 
	  
	// !!!!! désactive event de Ninja Form !!!!!!
	let submitField = document.querySelector("#nf-field-52-wrap");
	submitField.replaceWith(submitField.cloneNode(true));
	  
	  // In Form Send, add brevo form
    let submitButton = document.querySelector("#nf-field-52");
    submitButton.setAttribute("type", "button");
    submitButton.addEventListener("click", formValidationAndSwitchToPayment);
  }, 1000);
});

/**
 * Starting point of the all the check and payment function, check form first, 
 * and add payment windows before adding all event listener
 */
const formValidationAndSwitchToPayment = () => {
  let result = checkNinjaForm();
  if (!result.success) {
    window.scrollBy(0, -400);
    return;
  }

  let fields = document.querySelectorAll(".nf-field-element *");
  for (let i = 0; i < fields.length; i++) {
    fields[i].disabled = true;
  }

  window.scrollBy(0, 400);

  // set data in file racine from form
  validData = result.data;

  setupPaymentWindows(result.data);
  setupDeferPayment();
  setupStripePayment();
}

function computeSharePrice() {
  const nbPartsElement = document.querySelector('.nb-parts'); 
  const totalElement = document.querySelector('#total');
  const nbPartsValue = parseInt(nbPartsElement.value);
  const total = PU_SHARE * nbPartsValue;
  if (total == NaN) {
	totalElement.innerHTML = 0 + '€';
  }
  else {
	totalElement.innerHTML = total + '€';
  }
}
	
const checkNinjaForm = () => {
  resetTrigger();

  let error_ids = [];

  // get all data
  let data = {};

  data.civility = "";
  for (let i = 0; i < 2; i++) {
    let field = document.getElementById("nf-field-32-"+ i);
    if (field.checked) {
      data.civility = field.value;
    }
  }
  if (data.civility == ""){
    error_ids.push("32");
  }

  data.lastName = document.getElementById("nf-field-33").value;
  if (data.lastName == ""){
    error_ids.push("33");
  }

  data.firstName = document.getElementById("nf-field-34").value;
  if (data.firstName == ""){
    error_ids.push("34");
  }

  data.birthday = document.getElementById("nf-field-53").value;
  if (data.birthday == ""){
    error_ids.push("53");
  }

  data.address = document.getElementById("nf-field-36").value;
  if (data.address == ""){
    error_ids.push("36");
  }

  data.postcode = document.getElementById("nf-field-37").value;
  if (data.postcode == ""){
    error_ids.push("37");
  }

  data.city = document.getElementById("nf-field-38").value;
  if (data.city == ""){
    error_ids.push("38");
  }

  data.email = document.getElementById("nf-field-39").value;
  const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
  if (data.email == "" || !emailRegex.test(data.email)){
    error_ids.push("39");
  }

  data.phone = document.getElementById("nf-field-40").value;
  let length = data.phone.length;
  if ( length != 10 || data.phone.charAt(0) != '0') {
    if (data.phone == "" || data.phone.charAt(0) != '+' ){
      error_ids.push("40");
    }
  }
 

  data.isMember = "";
  for (let i = 0; i < 2; i++) {
    let field = document.getElementById("nf-field-41-"+ i);
    if (field.checked) {
      data.isMember = field.value;
    }
  }
  if (data.isMember == ""){
    error_ids.push("41");
  }

  data.category = [];
  for (let i = 0; i < 6; i++) {
    let field = document.getElementById("nf-field-55-"+ i);
    if (field.checked) {
      data.category.push(field.value);
    }
  }
  if (data.category.length == 0){
    error_ids.push("55");
  }

  data.share = parseInt(document.getElementById("nf-field-44").value);
  if (data.share == "" || data.share < 1 || !Number.isInteger(data.share)){
    error_ids.push("44");
  }

  data.comment = document.getElementById("nf-field-46").value;

  if (!document.getElementById("nf-field-43").checked) {
    error_ids.push("43");
  }

  if (!document.getElementById("nf-field-47").checked) {
    error_ids.push("47");
  }

  if ( error_ids.length > 0 ){
    triggerFormError(error_ids);
    return {success: false, data: data, error: "error in form", error_ids : error_ids};
  }

  // check if Stripe Element is not created
  if (document.getElementById("payment-form") != null || document.getElementById("payment-form") != undefined){
    return {success: false, data: data, error: "payment form created"};
  }

  return {success: true, data: data};
}

const triggerFormError = (ids) => {
  let ids_to_check = [ "33", "34", "53", "36", "37", "38", "39", "40", "43", "44", "47"];
  for (let i = 0; i < ids_to_check.length; i++) {
    let field = document.getElementById("nf-field-"+ids_to_check[i]);
    field.dispatchEvent(new Event("input"));
    field.dispatchEvent(new Event("blur"));
  }

  exception_ids = [ "32", "41", "55", "44"];
  for (let i = 0; i < ids.length; i++) {
    if (exception_ids.includes(ids[i])){
      let field = document.getElementById("nf-field-"+ids[i]+"-wrap");
      field.classList.add("nf-fail", "nf-error");
    }
  }
}

const resetTrigger = () => {
  ids = [ "32", "41", "55", "44"];
  for (let i = 0; i < ids.length; i++) {
    let field = document.getElementById("nf-field-"+ids[i]+"-wrap");
    field.classList.remove("nf-fail", "nf-error");
  }
}

function setupPaymentWindows(data) {
  // create payment form an insert it after ninja form
  let div = document.createElement("div");
  div.setAttribute("id", "payment-section");
  div.innerHTML = `
  <div id="payment-windows">
    <span class="title">Total: ${data.share * 50}€</span>
    <div id="card">
        <div class="payment-container"> 
            <input id="payment_method_stripe" type="radio" class="payment-radio" name="payment_method" value="card" >
            <label for="payment_method_stripe">Carte bancaire</label>
            <span class="img-container">
              <img src="${child_theme.url}/img/visa.svg"></img>
              <img src="${child_theme.url}/img/mastercard.svg"></img>
            </span>
        </div>
        <div id="payment-form" class="hidden">
            <div id='card-element'></div>
            <div id='payment-messages' role="alert"></div>
        </div>
    </div>
    <div id="cheque">
        <div class="payment-container"> 
            <input id="payment_method_cheque" type="radio" class="payment-radio" name="payment_method" value="cheque" >
            <label for="payment_method_cheque">Chèque envoyé ce jour à l’ordre de la SCIC SYPRÈS</label>
            <span class="img-container"></span>
        </div>
    </div>
    <div id="transfer">
        <div class="payment-container"> 
            <input id="payment_method_transfer" type="radio" class="payment-radio" name="payment_method" value="transfer" >
            <label for="payment_method_transfer">Virement au compte de la SCIC SYPRÈS --- IBAN : FR76 1444 5004 0008 0057 8890 672 (Pensez à indiquer votre Nom et Prénom dans le motif de paiement)</label>
            <span class="img-container"></span>
        </div>
    </div>
  </div>
  <div class="payment-button-container">
      <button id="submit-stripe" class="hidden">Payer</button>
      <button id="submit-defer-payment" class="hidden">Envoyer la demande</button>
      <span class="loader hidden" id="payment_loader"></span>
  </div>`;
  document.querySelector(".et_pb_section.et_pb_section_2.et_section_regular").appendChild(div);

  let radioButtons = document.querySelectorAll(".payment-radio");
  for (let i = 0; i < radioButtons.length; i++) {
    radioButtons[i].addEventListener("change", switchPaymentOpen);
  }
}

function switchPaymentOpen() {
  let buttonStripe = document.getElementById("submit-stripe");
  let buttonDefer = document.getElementById("submit-defer-payment");
  let stripeForm = document.getElementById("payment-form");
  buttonStripe.classList.add("hidden");
  buttonDefer.classList.add("hidden");
  stripeForm.classList.add("hidden");
  let radioButtons = document.querySelectorAll(".payment-radio");
  for (let i = 0; i < radioButtons.length; i++) {
    if (radioButtons[i].checked) {
      let value = radioButtons[i].value;
      switch (value) {
        case "card" :
          buttonStripe.classList.remove("hidden");
          stripeForm.classList.remove("hidden");
          break;
        default :
          buttonDefer.classList.remove("hidden");
      }
      return;
    }
  }
}

const setupDeferPayment = () => {
  document.getElementById("submit-defer-payment").addEventListener("click", async (e) => {
    e.preventDefault();
    revealLoader();
    let radioButtons = document.querySelectorAll(".payment-radio");
    for (let i = 0; i < radioButtons.length; i++) {
      if (radioButtons[i].checked) {
        let value = radioButtons[i].value;
        if (value == "cheque" || value == "transfer") {
          let formData = validData;
          formData.payment = value;
          validRegisterAndSendToBack(formData);
        }
      }
    }
  })
}

const setupStripePayment = async () => {

  // fetch API Key
  let dataSend = new FormData();
  dataSend.append("action", "sypres_get_stripe_api_key");

  const response = await postRequest(my_ajax_object.ajax_url, dataSend);
  
  // Init stripe ( with stripe script )
  const stripe = Stripe(response);

  // Create Stripe element and fix it to the payment form
  const appearance = {theme: 'stripe'};

  const elements = stripe.elements( { appearance } );
  const card = elements.create('card', {
    style: {
      base: {
        fontWeight: '500',
        fontSize: '18px',
      },
    },
    hidePostalCode : true
  });
  card.mount('#card-element');

  // add event listener to form
  let stripeButton = document.getElementById('submit-stripe');
  let submitted = false;

  stripeButton.addEventListener('click', async (e) => {
    e.preventDefault();
    revealLoader();
    // Disable double submission of the form
    let button = document.getElementById('submit-stripe');

    if(submitted) { return; }
    submitted = true;
    button.disabled = true;

    // Make a call to the server to create a new
    // payment intent and store its client_secret.
    let dataSend = new FormData();
    dataSend.append("action", "sypres_client_secret");
    dataSend.append("amount", validData.share);
    dataSend.append("currency", "eur");
    dataSend.append("paymentMethodType", "card");

    const data = await postRequest(my_ajax_object.ajax_url, dataSend);

    if ( data === false || !data.success ) {
        !data.success ? addMessage(data.error) : addMessage("Erreur lors de l'envoie des données");
        hideLoader();
        // reenable the form.
        submitted = false;
        button.disabled = false;
        return;
    }

    addMessage(`Demande de paiement reçu`);

    // Confirm the card payment given the clientSecret
    // from the payment intent that was just created on
    // the server.
    const {error: stripeError, paymentIntent} = await stripe.confirmCardPayment(
      data.client_secret,
      {
        payment_method: {
          card: card,
          billing_details: {
             name: validData.firstName,
          },
        },
      }
    );
    
    if (stripeError) {
      addMessage(stripeError.message);
      hideLoader();
      // reenable the form.
      submitted = false;
      button.disabled = false;
      return;
    }

    //addMessage(`Payment ${paymentIntent.status}: ${paymentIntent.id}`);
    addMessage(`Paiement Validé`);
    let formData = validData;
    formData.payment = "card";
    validRegisterAndSendToBack(formData, paymentIntent.client_secret);
  });
}

async function validRegisterAndSendToBack(data, client_secret = null) {
  let formData = new FormData();
  for ( let key in data ) {
    formData.append(key, data[key]);
  }
  if ( client_secret != null ){
    formData.append("client_secret", client_secret);
  }
  
  formData.append("action", "sypres_valid_member_payment");

  let response = await postRequest(my_ajax_object.ajax_url, formData);
  if (!response) {
    return;
  }

  window.location.href = response.url;
}

function revealLoader() {
  document.getElementById("payment_loader").classList.remove("hidden");
}

function hideLoader() {
  document.getElementById("payment_loader").classList.add("hidden");
}

async function postRequest(  url, data, header = {} ) {
  const response = await fetch(url, {
    method: 'POST',
    header: header,
    body: data,
  });

  if (!response.ok) {
    return false;
  }
  let res_data = await response.json();
  return res_data.data;
}

const addMessage = (message) => {
  document.getElementById("payment-messages").innerHTML = " > " + message;
}