document.addEventListener('DOMContentLoaded', function () {
    initFaq();
    initFaqCloseButton();
    initNav();
    scrollFromTop();
    initCarousel();
    initForm();
    initArticle();
    initDevis();
    initMovableContainer();
    initSouscription();
});

function initFaq() {
    let questions = document.querySelectorAll('.faq .question');
    for (let i = 0; i < questions.length; i++) {
        questions[i].addEventListener('click', function (e) {
            let question = e.target;
            while ( !question.classList.contains('question')) {
                question = question.parentElement;
            }

            let response = question.parentElement.querySelector('.response');
            response.style.maxHeight = response.scrollHeight;

            if (question.classList.contains('open') ) {
                response.classList.add('close');
                question.classList.remove('open');
            }
            else {
                response.classList.remove('close');
                question.classList.add('open');
            }
        })
    }
}

function initFaqCloseButton() {
    if ( !document.getElementById('faq-close-button') ) { return; }
    document.getElementById('faq-close-button').addEventListener('click', () => {
        let questions = document.querySelectorAll('.faq .container[data-closable="1"]');
        if ( questions.length == 0 ) { return; }
        if (questions[0].classList.contains('hidden')) {
            for (let i = 0; i < questions.length; i++) {
                questions[i].classList.remove('hidden');
            }
            document.getElementById('faq-close-button').innerHTML = "Fermer";
        }
        else {
            for (let i = 0; i < questions.length; i++) {
                questions[i].classList.add('hidden');
            }
            document.getElementById('faq-close-button').innerHTML = "TOUT VOIR";
        }
    });
}

function initNav() {
    let items = document.querySelectorAll('.nav-menu.desktop .container');
    for (let i = 0; i < items.length; i++) {
        if ( !document.querySelector('.nav-menu.desktop [data-window="'+ (i + 1) +'"]')) { continue; }
        
        items[i].addEventListener('mouseover', function (e) {
            let item = e.target;
            while ( !item.classList.contains('container')) {
                item = item.parentElement;
            }

            let win = document.querySelector('.nav-menu.desktop [data-window="'+ item.dataset.menu +'"]');
            if (win) win.classList.remove('hidden');
        });

        items[i].addEventListener('mouseout', function (e) {
            let item = e.target;
            while ( !item.classList.contains('container')) {
                item = item.parentElement;
            }

            let win = document.querySelector('.nav-menu.desktop [data-window="'+ item.dataset.menu +'"]');
            if (win) win.classList.add('hidden');
        });
    }

    items = document.querySelectorAll('.window-mobile .container');
    for (let i = 0; i < items.length; i++) {
        if ( !document.querySelector('.window-mobile [data-window="'+ (i + 1) +'"]')) { continue; }
        
        items[i].addEventListener('click', function (e) {
            let item = e.target;
            while ( !item.classList.contains('container')) {
                item = item.parentElement;
            }

            let win = document.querySelector('.window-mobile [data-window="'+ item.dataset.menu +'"]');
            
            if ( !win ) { return; }
            win.classList.contains('hidden') ? 
                win.classList.remove('hidden') :
                win.classList.add('hidden');
        });
    }

    document.querySelector('.nav-open').addEventListener('click', function () {
        document.querySelector('.nav-open').classList.add('hidden');
        document.querySelector('.nav-close').classList.remove('hidden');
        document.querySelector('.window-mobile').classList.remove('hidden');
    });

    document.querySelector('.nav-close').addEventListener('click', function () {
        document.querySelector('.nav-open').classList.remove('hidden');
        document.querySelector('.nav-close').classList.add('hidden');
        document.querySelector('.window-mobile').classList.add('hidden');
    });



}

function scrollFromTop() {
    window.addEventListener('scroll', function() {
        if (window.scrollY > 0) {
            document.querySelector('header').classList.add('scrolled');
        } else {
            document.querySelector('header').classList.remove('scrolled');
        }
    });
}

function initCarousel() {
    let carousels = document.querySelectorAll(".slides");
    for (let i = 0; i < carousels.length; i++) {

        function showSlide(slides) {
            const length = slides.children[0].offsetWidth + 24;
            let translation = length * slides.dataset.index + 10;
            translation = translation < 0 ? 0 : translation;
            slides.style.transform = "translateX(-" + translation + "px)";
        }

        carousels[i].parentElement.querySelector('.next-slide').addEventListener('click', (e) => {
            let slides = getCarouselParent(e);
            let index = slides.dataset.index;
            let actualTotal = slides.children.length - 1 - correctionIndexByOffset(slides);
            index = index == 0 ? 
                actualTotal :
                parseInt(index) - 1;
            slides.dataset.index = index;
            showSlide(slides);
        });

        carousels[i].parentElement.querySelector('.preview-slide').addEventListener('click', (e) => {
            let slides = getCarouselParent(e);
            let index = slides.dataset.index;
            let actualTotal = slides.children.length  - 1 - correctionIndexByOffset(slides);
            index = index == actualTotal ? 
                0 :
                parseInt(index) + 1;
            slides.dataset.index = index;
            showSlide(slides);
        });

        showSlide(carousels[i]);
    }

}

function correctionIndexByOffset( slides ) {
    offsetIndex = Math.floor( slides.parentElement.offsetWidth / slides.children[0].offsetWidth );
    return offsetIndex == 0 ? offsetIndex : offsetIndex - 1;
}

function getCarouselParent( event ) {
    let slides = event.target;
    while ( !slides.classList.contains('carousel') ) {
        slides = slides.parentElement;
    }
    return slides.querySelector('.slides');
}


function initForm() {
    let forms = document.querySelectorAll('form');
    
    for (let i = 0; i < forms.length; i++) {
        if ( forms[i].dataset.listener == "none" || forms[i].id == "commentform" || forms[i].id == "form-avis" ) { continue; }
        forms[i].addEventListener('submit', async (e) => {
            e.preventDefault();
            let form = e.target;
            let url = ajaxObject.url;
            
            let data = new FormData(form);
            fetch( url, {
                method: 'POST',
                body: data,
            }) 
            .then(response => response.json())
            .then(result => {
                data = result.data;
                form.querySelector('.information' + (data.success ? '.success' : '.echec'))?.classList.remove('hidden');
                form.querySelector('.information' + (!data.success ? '.success' : '.echec'))?.classList.add('hidden');

                if (data.url) {
                    setTimeout(() => {
                        window.location.href = data.url;
                    }, 2000);
                }
            });
        });
    }
}

function initArticle() {
    if (!document.querySelector('.page-article')) {
        return;
    }

    const bannerHeight = document.querySelector('header').clientHeight + 2;
    const paddingY = 16;
    const vericalBlank = bannerHeight + paddingY;
    const parentDiv = document.querySelector('.header-wrapper');
    const innerDiv = document.querySelector('.header-wrapper .header');
    const parentHeight = parentDiv.clientHeight;
    const innerWidth = innerDiv.clientWidth;
    const innerHeight = innerDiv.clientHeight;
    const plage = parentHeight - innerHeight - 2 * vericalBlank - 2 * paddingY - 60;
    const fw = window.screen.width;
    const fh = document.querySelector('.second-menu').clientHeight;// .screen.height;
    const diffW = fw - innerWidth;
    const diffH = fh - innerHeight;

    window.addEventListener('scroll', function(event) {
        const scrollPosition = innerDiv.offsetTop - bannerHeight;
        let perc = scrollPosition / plage * 100;

        if ( perc > 100 ){
            perc = 100;
        }
        if ( perc < 0 ){
            perc = 0;
        }

        const marginW = diffW / 2 * perc / 100;
        let opacity = 1 - (perc / 1.5 / 100);
        
        if ( perc > 75 ){
            opacity = 1 - (perc / 100);
        }

        document.querySelector('.header-wrapper .intro').style.opacity = opacity;

        let header = document.querySelector('.header-wrapper .header');
        if ( perc >= 0 ){
            //const proportion = (perc - 50) / (100 - 50);
            //perc = proportion  * 100;
            const marginH = diffH * perc / 100;
            //const newTop = oriInnerOffsetTop - (diffH / 2 * perc / 100);
            let newHeight = innerHeight +  marginH 

            if ( newHeight < innerHeight ){
                newHeight = innerHeight;
            }

            const newDiffH = fh - newHeight;
            let newTop = newDiffH / 2; 

            if ( newTop > paddingY + bannerHeight ){
                newTop = paddingY + bannerHeight;
            }

            header.style.marginLeft = -marginW + "px";
            header.style.marginRight = -marginW + "px";
            header.style.top = newTop + "px";
            header.style.height = newHeight + "px";
        } else {
            header.style.marginLeft = 0;
            header.style.marginRight = 0;
            header.style.top = newTop + paddingY + bannerHeight;
            header.style.height = 'calc(100vh - ' + (2 * bannerHeight) + ')';
        }

        if ( window.scrollY > ( parentHeight - 400) ){
            header.classList.add('active');
        } else {
            header.classList.remove('active');
        }
    });
}


function initDevis() {
    let devis = document.getElementById('devis');
    if ( !devis ) { return; }

    // Refacto possible for automaticly add all
    devis.querySelector('.type.inhumation').addEventListener('click', () => {
        document.querySelector('.obseque.inhumation').classList.remove('hidden');
        hideDevisSelector();
    });

    devis.querySelector('.type.cremation').addEventListener('click', () => {
        document.querySelector('.obseque.cremation').classList.remove('hidden');
        hideDevisSelector();
    });

    let returnButtons = devis.querySelectorAll('.return');
    for (let i = 0; i < returnButtons.length; i++) {
        returnButtons[i].addEventListener('click', () => {
            showDevisSelector();
        });
    }
}

function hideDevisSelector() {
    document.querySelector('#devis .selector').classList.add('hidden');
}

function showDevisSelector() {
    document.querySelector('#devis .selector').classList.remove('hidden');
    let obsequesTypes = document.querySelectorAll('#devis .obseque');
    for (let i = 0; i < obsequesTypes.length; i++) {
        obsequesTypes[i].classList.add('hidden');
    }
}

function initMovableContainer() {
    let inputs = document.querySelectorAll('.container-movable input');
    let textarea = document.querySelectorAll('.container-movable textarea');
    for (let i = 0; i < inputs.length; i++) {
        inputs[i].addEventListener('input', movableFieldListener );
    }
    for (let i = 0; i < textarea.length; i++) {
        textarea[i].addEventListener('input', movableFieldListener );
    }
}

function movableFieldListener(e) {
    let movable = e.target.parentElement.querySelector('.movable');
    if ( e.target.value == "" ) {
        movable.style.top = "5px";
        movable.style.left = '10px';
        return;
    }
    movable.style.top = "-30px";
    movable.style.left = '0px';
}

// PAYMENT SOCIAL SHARE

let formValid = false;
let validData = {};
const PU_SHARE = 50;

function initSouscription() {
    if ( !document.getElementById('form-social-share')) { return; }

    initSocialShareForm();

    let share = document.getElementById('share');
    if (share) { 
        share.addEventListener('keyup', computeSharePrice);
        share.addEventListener('change', computeSharePrice);
    }

    let radioButtons = document.querySelectorAll(".payment-radio");
    for (let i = 0; i < radioButtons.length; i++) {
        radioButtons[i].addEventListener("change", switchPaymentOpen);
    }

    setupStripePayment();
    setupDeferPayment();
}

function initSocialShareForm() {
    document.getElementById('form-social-share').addEventListener('submit', (e) => {
        e.preventDefault();
        document.getElementById('payment-windows').classList.remove('hidden');
        let data = new FormData(e.target);
        for (let pair of data.entries()) {
            validData[pair[0]] = pair[1];
        }
    });
}

function computeSharePrice(e) {
    document.getElementById('numberOfPartTotal').innerHTML = e.target.value * 50;
    document.getElementById('numberOfPartTotalPaiement').innerHTML = e.target.value * 50;
}

function switchPaymentOpen() {
  let buttonStripe = document.getElementById("submit-stripe");
  let buttonDefer = document.getElementById("submit-defer-payment");
  let stripeForm = document.getElementById("payment-form");
  buttonStripe.classList.add("hidden");
  buttonDefer.classList.add("hidden");
  stripeForm.classList.add("hidden");
  let radioButtons = document.querySelectorAll(".payment-radio");
  for (let i = 0; i < radioButtons.length; i++) {
    if (radioButtons[i].checked) {
      let value = radioButtons[i].value;
      switch (value) {
        case "card" :
          buttonStripe.classList.remove("hidden");
          stripeForm.classList.remove("hidden");
          break;
        default :
          buttonDefer.classList.remove("hidden");
      }
      return;
    }
  }
}

function setupDeferPayment() {
  document.getElementById("submit-defer-payment").addEventListener("click", async (e) => {
    e.preventDefault();
    revealLoader();
    let radioButtons = document.querySelectorAll(".payment-radio");
    for (let i = 0; i < radioButtons.length; i++) {
      if (radioButtons[i].checked) {
        let value = radioButtons[i].value;
        if (value == "cheque" || value == "transfer") {
          let formData = validData;
          formData.payment = value;
          validRegisterAndSendToBack(formData);
        }
      }
    }
  })
}

async function setupStripePayment() {
    
    // fetch API Key
    let dataSend = new FormData();
    dataSend.append("action", "sypres_get_stripe_api_key");

    const response = await postRequest(ajaxObject.url, dataSend);
    
    // Init stripe ( with stripe script )
    const stripe = Stripe(response);

    // Create Stripe element and fix it to the payment form
    const appearance = {theme: 'stripe'};

    const elements = stripe.elements( { appearance } );
    const card = elements.create('card', {
        style: {
        base: {
            fontWeight: '500',
            fontSize: '18px',
        },
        },
        hidePostalCode : true
    });
    card.mount('#card-element');

    // add event listener to form
    let stripeButton = document.getElementById('submit-stripe');
    let submitted = false;

    stripeButton.addEventListener('click', async (e) => {
        e.preventDefault();
        revealLoader();

        // Disable double submission of the form
        let button = document.getElementById('submit-stripe');

        if(submitted) { return; }
        submitted = true;
        button.disabled = true;

        // Make a call to the server to create a new
        // payment intent and store its client_secret.
        let dataSend = new FormData();
        dataSend.append("action", "sypres_client_secret");
        dataSend.append("amount", validData.share);
        dataSend.append("currency", "eur");
        dataSend.append("paymentMethodType", "card");

        const data = await postRequest(ajaxObject.url, dataSend);

        if ( data === false || !data.success ) {
            !data.success ? addMessage(data.error) : addMessage("Erreur lors de l'envoie des données");
            hideLoader();
            // reenable the form.
            submitted = false;
            button.disabled = false;
            return;
        }

        addMessage(`Demande de paiement reçu`);

        // Confirm the card payment given the clientSecret
        // from the payment intent that was just created on
        // the server.
        const {error: stripeError, paymentIntent} = await stripe.confirmCardPayment(
        data.client_secret,
        {
            payment_method: {
                card: card,
                billing_details: {
                    name: validData.firstName,
                },
            },
        }
        );
        
        if (stripeError) {
            addMessage(stripeError.message);
            hideLoader();
            // reenable the form.
            submitted = false;
            button.disabled = false;
            return;
        }

        //addMessage(`Payment ${paymentIntent.status}: ${paymentIntent.id}`);
        addMessage(`Paiement Validé`);
        let formData = validData;
        formData.payment = "card";
        validRegisterAndSendToBack(formData, paymentIntent.client_secret);
    });
}

async function validRegisterAndSendToBack(data, client_secret = null) {
  let formData = new FormData();
  for ( let key in data ) {
    formData.append(key, data[key]);
  }
  if ( client_secret != null ){
    formData.append("client_secret", client_secret);
  }
  
  formData.append("action", "sypres_valid_member_payment");

  let response = await postRequest(ajaxObject.url, formData);
  if (!response) {
    return;
  }

  window.location.href = response.url;
}


function revealLoader() {
  document.getElementById("payment_loader").classList.remove("hidden");
}

function hideLoader() {
  document.getElementById("payment_loader").classList.add("hidden");
}

async function postRequest(  url, data, header = {} ) {
  const response = await fetch(url, {
    method: 'POST',
    header: header,
    body: data,
  });

  if (!response.ok) {
    return false;
  }
  let res_data = await response.json();
  return res_data.data;
}

const addMessage = (message) => {
  document.getElementById("payment-messages").innerHTML = " > " + message;
}