<?php
/*
  Plugin Name: Taketik Bulk Images
  Description: Gestion par lot des alt/nom des images 
  Author: Taketik
  Version: 1.0.1
*/

namespace Taketik;

class BI{
	public function  __construct(){
		add_action('admin_menu', function () {
			$page_title = 'Images par lot';
			$menu_title = 'Images par lot';
			$capability = 'manage_options';
			$menu_slug  = 'taketik-bi';
			$function   = [$this, 'main'];
			add_menu_page($page_title, $page_title, $capability, $menu_slug, $function, 'dashicons-format-gallery');
			add_submenu_page('taketik-bi-main', $page_title, $page_title, $capability, $menu_slug, $function);
		});

		add_action('admin_enqueue_scripts', function(){
			$root = plugin_dir_url(__FILE__);
			wp_enqueue_style('taketik-bi-style', $root  . 'assets/css/style.css', [], '1.0.10');
			wp_enqueue_script('taketik-bi-script', $root . 'assets/js/main.js', ['jquery'], '1.0.1');
			wp_localize_script( 'taketik-bi-script', 'my_ajax_object', array( 'ajax_url' => admin_url( 'admin-ajax.php' ) ) );
		});

		add_action( 'wp_ajax_taketik_rename_image', [$this, 'ajaxRenameOneImage']);
	}

	private function getAllImages(int $limit = -1): array{
		$args = array(
			'post_type'      => 'attachment',
			'post_mime_type' => 'image',
			'post_status'    => 'inherit',
			'posts_per_page' => $limit,
		);

		return get_posts($args);
	}

	private function renameImage(int $image_id, string $old_fn, string $new_fn, string $ext){
		$metas = wp_get_attachment_metadata($image_id);
		$post = get_post($image_id);
		$replaces = [];
		$replaces[] = ['old' => $old_fn . '.' . $ext, 'new' => $new_fn . '.' . $ext];
		$full_fn = get_attached_file($image_id);
		$pi = pathinfo($full_fn);
		$path = $pi['dirname'] . '/';
		$result = true;

		//replace main file
		if ( $this->renameOneFile($path, $old_fn . '.' . $ext, $new_fn . '.' . $ext) ){
			$oldFile = $metas['file'];
			$metas['file'] = str_replace($old_fn . '.' . $ext, $new_fn . '.' . $ext, $metas['file']);
			$newFile = $metas['file'];
			$this->renameImageInPosts($oldFile, $newFile);

			$post_data = array(
				'ID'         => $image_id,
				'post_title' => $new_fn,
			);
			$meta_file = get_post_meta($image_id, '_wp_attached_file', true);
			update_post_meta($image_id, '_wp_attached_file', str_replace($old_fn, $new_fn, $meta_file));
			wp_update_post($post_data);
		} else {
			$result = false;
		}

		//replace meta variants files
		$newSizes = [];

		if ( isset($metas['sizes']) && is_array($metas['sizes'])){
			foreach ( $metas['sizes'] as $size ){
				if ( $result == false ){
					continue;
				}

				$w = $size['width'];
				$h = $size['height'];
				$variant_old_fn = $old_fn . '-' . $w . 'x' . $h . '.' . $ext;
				$variant_new_fn = $new_fn . '-' . $w . 'x' . $h . '.' . $ext;

				if ( $this->renameOneFile($path, $variant_old_fn, $variant_new_fn) ){
					$size['file'] = str_replace($variant_old_fn, $variant_new_fn, $size['file']);
				} else {
					$result = false;
				}

				$newSizes[] = $size;
			}
		}

		if ( $result == true ){
			$metas['sizes'] = $newSizes;
			wp_update_attachment_metadata($image_id, $metas);
		}

		return $result;
	}

	private function renameOneFile(string $path, string $oldFn, string $newFn){
		if ( file_exists($path.$oldFn)){
			return @rename($path.$oldFn, $path.$newFn);
		}

		return false;
	}

	private function renameImageInPosts(string $old_fn, string $new_fn){
		$args = array(
				'post_type'      => 'any',
				'posts_per_page' => -1,
				'fields'         => 'ids',
				's'              => $old_fn,
		);

		$posts = get_posts($args);

		foreach ($posts as $post_id) {
			$post_content = get_post_field('post_content', $post_id);
			$updated_content = str_replace($old_fn, $new_fn, $post_content);

			$post_data = array(
					'ID'           => $post_id,
					'post_content' => $updated_content,
			);

			wp_update_post($post_data);
		}
	}

	private function extractExtension(string $fn){
		$fns = explode(".", $fn);
		$ext = array_pop($fns);

		return ['fn' => implode('.', $fns), 'ext' => $ext];
	}

	public function ajaxRenameOneImage(){
		$result = ['status' => 'KO'];

		if ( !isset($_POST['id']) || !isset($_POST['old_fn']) || !isset($_POST['ext']) || !isset($_POST['new_fn']) || !isset($_POST['new_alt'])){
			echo json_encode($result);
			exit;
		}

		$image_id = $_POST['id'];
		$alt = $_POST['new_alt'];
		$old_fn = $_POST['old_fn'];
		$fn = $_POST['new_fn'];

		update_post_meta($image_id, '_wp_attachment_image_alt', $alt);
		$result['status'] = 'OK';

		if ( $old_fn != $fn ){
			if ( !$this->renameImage($image_id, $old_fn, $fn, $_POST['ext']) ){
				$result['status'] = 'KO';
			}
		}

		echo json_encode($result);
		exit;
	}

	/*
	private function dealWithPost(){
		if ( !isset($_POST['bulk'])){
			return;
		}

		foreach ( $_POST['images'] as $image_id ){
			echo "<br> ".$image_id;

			if ( isset($_POST['old_alts'][$image_id]) && isset($_POST['alts'][$image_id])){
				$old_alt = $_POST['old_alts'][$image_id];
				$alt = $_POST['alts'][$image_id];
				echo "<br>&nbsp;&nbsp;&nbsp;$old_alt => $alt";
				if ( $old_alt != $alt ){
					update_post_meta($image_id, '_wp_attachment_image_alt', $alt);
				}
			}
			if ( isset($_POST['old_fns'][$image_id]) && isset($_POST['fns'][$image_id]) && isset($_POST['exts'][$image_id])){
				$old_fn = $_POST['old_fns'][$image_id];
				$fn = $_POST['fns'][$image_id];

				if ( $old_fn != $fn ){
					echo "<br>&nbsp;&nbsp;&nbsp;$old_fn => $fn";
					$this->renameImage($image_id, $old_fn, $fn, $_POST['exts'][$image_id]);
				}
			}
		}

	}
	*/

	public function main(){
		$images = $this->getAllImages();

		if ( !count($images) ){
			echo '<h2>Aucune image dans la bibliothèque</h2>';
			return;
		}

		?>
		<table class="image-table">
			<thead>
				<tr>
					<th class="left">Image</th>
					<th class="left">Informations</th>
				</tr>
			</thead>
			<tbody>
				<?php
					foreach ( $images as $image ){
						$image_id = $image->ID;
						$image_alt = get_post_meta($image_id, '_wp_attachment_image_alt', true);
						$file_path = get_attached_file($image_id);
						$file_name = wp_basename($file_path);
						['fn'=> $fn, 'ext' => $ext] = $this->extractExtension($file_name);

						?>
						<tr>
							<td><?= wp_get_attachment_image($image_id, [150, 150]);?></td>
							<td class="infos">
								<div class="form-group">
									<label for="alt-<?= $image_id;?>">Alt :</label>
									<input id="alt-<?= $image_id;?>" type="text" name="alts[<?= $image_id;?>]" value="<?= $image_alt;?>">
								</div>
								<div class="form-group">
									<label for="fn-<?= $image_id;?>">Nom du fichier :</label>
									<input id="fn-<?= $image_id;?>" type="text" name="fns[<?= $image_id;?>]" value="<?= $fn;?>">
								</div>
								<div class="left">
									<span class="error cache">KO</span>
									<span class="success cache">OK</span>
									<button class="save-image" data-id="<?= $image_id;?>" data-ext="<?= $ext;?>" data-old="<?= $fn;?>"><span class="txt">Enregistrer</span> <div class="btn-spinner"><span class="lds-dual-ring"></span></div></button>
								</div>
							</td>
						</tr>
						<?php
					}
				?>
			</tbody>
		</table>
		<?php
	}
}

$bp = new BI();