<?php
/**
 * Plugin Name: Carte Interactive des Coopératives Funéraires
 * Author: Taketik
 * Description: Affiche une carte interactive des coopératives Funéraires.
 * Version: 1.0.1
 * @author Taketik
 * Author URI: https://taketik.fr/
 */

require_once("Function.php");
require_once("Page.php");
require_once("MapSVG.php");
require_once("PinSVG.php");
require_once("PhoneSVG.php");
require_once("MailSVG.php");

register_activation_hook(__FILE__, function() {
    // Je suis activé
});

register_deactivation_hook(__FILE__, function () {
    // Je suis désactivé
});
add_action('init', function () {
    add_shortcode('interactive-map', 'addMapShortCode');
});

function addMapShortCode( $atts = array(), $content = null, $tag = '' ) {
    $atts = array_change_key_case( (array) $atts, CASE_LOWER );
    $interractive_atts = shortcode_atts(
		array(
			'width' => '60',
			'min-width' => '300',
            'map-color' => '#808080',
            'pin-color' => 'white',
            'menu-left' => '100',
            'menu-translate' => '0',
		), $atts, $tag
	);

    $data = getMapData();
    $mapPositions = [];
    if ( $data == null ) return '';
    foreach ($data['points'] as $point) {
        $mapPositions[] = $point["sum"];
    }
    $mapPositions = array_unique($mapPositions);
    return getInterractiveMap($data, $mapPositions, $interractive_atts);
}

function getMapData(){
    $curl = curl_init();

    curl_setopt_array($curl, array(
    CURLOPT_URL => getInterractiveMapApiURL(),
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => "GET",
    CURLOPT_HTTPHEADER => 
        [ 
            "cache-control: no-cache"
        ],
    ));

    $response = curl_exec($curl);
    $err = curl_error($curl);
    curl_close($curl);
    
    $data = json_decode($response, true);
    if ($data == null) error_log(print_r('MAP: no data retrieved | err: '. $err, true));
    return $data;
}