<?php
function getInterractiveMap($data, $mapPositions, $atts) {
    ob_start();
?>
    <div class="map-container">
        <div class="map-block">
            <div class="map-img">
                <?= getMapSvg($atts['map-color']) ?>
            </div>
            <div class="tile-block">
                <?php for ($i=0; $i < $data['length'] * $data['length']; $i++) :?>
                    <div class="map-tile">
                        <?php if ( in_array($i, $mapPositions)): ?>
                            <div class="pin-img" onclick="showCoopList(<?= $i ?>)">
                               <?= getPinSVG($atts['pin-color']) ?>
                            </div>
                        <?php endif ?>
                    </div>
                <?php endfor ?>
            </div>
            <div id="displayer">
                
            </div>
        </div>
    </div>

    <script>
        let data = JSON.parse('<?php echo json_encode($data) ?>');
        let displayer = document.getElementById('displayer');
        console.log(data);
        

        function showCoopList(id) {
            let displayed = [];
            for (let i = 0; i < data['points'].length; i++) {
                if ( data.points[i].sum == id ) {
                    displayed.push(data.points[i]);
                }
            }
            let html = '<div class="close" onclick="closeDisplayer()"></div>';
            for (let i = 0; i < displayed.length - 1; i++) {
                html += getMapDisplayedHtml(displayed[i].nom, displayed[i].email, displayed[i].telephone, displayed[i].adresse, displayed[i].lien, displayed[i].ouverture_prochaine) + '<div class="map-separator"></div>';
            }
                html += getMapDisplayedHtml(displayed[displayed.length - 1].nom, displayed[displayed.length - 1].email, displayed[displayed.length - 1].telephone, displayed[displayed.length - 1].adresse, displayed[displayed.length - 1].lien, displayed[displayed.length - 1].ouverture_prochaine);
            displayer.innerHTML = html;
            displayer.style.display = 'flex';
        }

        function getMapDisplayedHtml( nom, email, tel, adresse, lien, prochaine) {
            let html = prochaine ? '<span class="italic">Prochainement :</span>' : '';
            html += nom ? '<span class="organisme">'+ nom +'</span>' : '';
            html += adresse ? '<span class="adresse">'+ adresse +'</span>' : '';
            html += email ? '<a href="mailto:'+email+'"><div class="svg mail"><?= getMailSVG($atts['map-color'], $atts['pin-color']) ?></div>Contactez-nous !</a>' : '';
            html += tel ? '<a href="tel:'+tel+'"><div class="svg phone"><?= getPhoneSVG($atts['map-color']) ?></div>'+formatTel(tel)+'</a>' : '';
            html += lien ? '<div class="website"><a href="'+ lien +'" target="_blank" class="website"><span class="organisme">Site Web</span></a></div>' : '';
            return html;
        }

        function formatTel(tel){
            var newvalue = "";
            for (var i = 0; i < tel.length; i++) {
                if ((i > 0) && (i % 2 == 0)) {
                    newvalue += '.';
                }
                newvalue += tel.charAt(i);
            }
            return newvalue;
        }

        function closeDisplayer() {
            displayer.style.display = 'none';
        }
    </script>

    <style>
        .map-container {
            color: black;
            width: 100%;
            height: fit-content;
            margin-top: 20px;
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            flex-direction: column;
        }

        .map-block {
            width: <?= $atts['width'] ?>%;
            min-width: <?= $atts['min-width'] ?>px;
            position: relative;
        }

        .map-img,
        .pin-img {
            width: 100%;
        }

        .tile-block {
            position: absolute;
            top: 0;
            right: 0;
            width: 100%;
            height: 100%;
            display: flex;
            flex-wrap: wrap;
            z-index: 10;
        }

        .map-tile {
            position: relative;
            padding: 0;
            background-color: transparent;
            width: <?= 100/$data['length'] ?>% ;
            height: <?= 100/$data['length'] ?>%;
            cursor: pointer;
        }

        .pin-img {
            position: absolute;
            bottom: 0%;
            left: 50%;
            transform: translate(-50%, 0%);
            min-width: 20px;
            min-height: 20px;
        }

        .italic {
            font-style: italic;
        }

        #displayer {
            min-width: 250px;
            color: black;
            background-color: white;
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-40%, -50%);
            display: none;
            z-index: 20;
            flex-direction: column;
            padding: 20px;
            border-radius: 10px;
            border: 1px black solid;
            overflow-y: auto;
            max-height: 90%;
        }

        @media (min-width: 1080px) { 
            #displayer {
                top: 50%;
                left: <?= $atts['menu-left'] ?>%;
                transform: translate(<?= $atts['menu-translate'] ?>%, -50%);
            }
        }

        @media (max-width: 600px) { 
            #displayer {
                left: 0;
                transform: translate(0,0);
                top: 0;
                width: 90%;
            }
        }

        #displayer a {
            color: black;
            z-index: 30;
            cursor: pointer;
            font-weight: 600;
            text-decoration: none;
            display: flex;
            align-items: center;
        }

        #displayer .website {
            margin-top: 5px;
            width: 100%;
            display: flex;
            justify-content: center;
        }

     
        #displayer .website a {
            justify-content: center;
            width: 100%;
            border-radius: 10px;
            background-color: <?= $atts['map-color'] ?>;
            color: <?= $atts['pin-color'] ?>;
            font-weight: 700;
        }

        #displayer .adresse {
            line-height: normal;
            margin-top: 5px;
        }

        #displayer .organisme {
            font-weight: 700;
            font-size: 20px;
        }

        #displayer .close {
            position: absolute;
            right: 10px;
            top: 10px;
            width: 15px;
            height: 15px;
            opacity: 0.3;
        }
        #displayer .close:hover {
            opacity: 1;
        }
        #displayer .close:before, .close:after {
            position: absolute;
            left: 5px;
            content: ' ';
            height: 15px;
            width: 2px;
            background-color: #333;
        }
        #displayer .close:before {
            transform: rotate(45deg);
        }
        #displayer .close:after {
            transform: rotate(-45deg);
        }

        #displayer .svg.phone {
            height: 20px;
            width: 20px;
            margin-right: 5px;
            margin-left: 5px;
        }

        #displayer .svg.mail {
            height: 30px;
            width: 30px;
        }

        .map-separator {
            margin-top: 15px;
            margin-bottom: 20px;
            width: 50%;
            height: 1px;
        }
    </style>

<?php 
    return ob_get_clean();
} 