<?php
/**
 * Plugin Name: Carte Interactive des Coopératives Funéraires Backoffice
 * Version: 1.0.1
 */

require_once("Function.php");
require_once("DataProviders.php");
require_once("Page.php");

$data = new DataProviders();

register_activation_hook(__FILE__, function() {
    // Je suis activé
});

register_deactivation_hook(__FILE__, function () {
    // Je suis désactivé
});

add_action( 'acf/init', function() {
	acf_add_options_page( array(
		'page_title' => 'Carte Interactive',
		'menu_slug' => 'carte-interactive',
		'redirect' => false,
	) );
} );

add_action('admin_menu', function() {
    if (isset($_GET['page']) && $_GET['page'] === 'carte-interactive' && count($_POST) == 0 ) {
		return getTemplateMap();
	}
}, 30);

add_action('rest_api_init', function () {
    // Register a custom route
    register_rest_route('interactive-map', '/get', [
        'methods'  => 'GET', // HTTP method (GET, POST, etc.)
        'callback' =>  'getRestResponse' , // Function to handle the request
        'permission_callback' => '__return_true', // Optional, grants access to all users
    ]);
});

function getRestResponse() {
	$data = new DataProviders();
	return new WP_REST_Response( $data->get(), 200 );
}